/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.tracing.samplers;

import com.newrelic.agent.config.SamplerConfig;
import com.newrelic.agent.tracing.samplers.AdaptiveSampler;
import com.newrelic.agent.tracing.samplers.AlwaysOffSampler;
import com.newrelic.agent.tracing.samplers.AlwaysOnSampler;
import com.newrelic.agent.tracing.samplers.ProbabilityBasedSampler;
import com.newrelic.agent.tracing.samplers.Sampler;
import com.newrelic.agent.tracing.samplers.TraceRatioBasedSampler;

public class SamplerFactory {
    public static final String ADAPTIVE = "adaptive";
    public static final String ALWAYS_ON = "always_on";
    public static final String ALWAYS_OFF = "always_off";
    public static final String PROBABILITY = "probability";
    public static final String TRACE_RATIO_ID_BASED = "trace_id_ratio_based";
    public static final String DEFAULT = "default";

    public static Sampler createSampler(SamplerConfig samplerConfig) {
        switch (samplerConfig.getSamplerType()) {
            case "always_on": {
                return new AlwaysOnSampler();
            }
            case "always_off": {
                return new AlwaysOffSampler();
            }
            case "probability": {
                return new ProbabilityBasedSampler(samplerConfig);
            }
            case "trace_id_ratio_based": {
                return new TraceRatioBasedSampler(samplerConfig);
            }
        }
        return AdaptiveSampler.getSharedInstance();
    }
}

