/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.service.module;

import com.newrelic.agent.service.module.JarData;
import com.newrelic.agent.service.module.URLAnalyzer;
import com.newrelic.agent.service.module.WeavePackageAnalyzer;
import com.newrelic.api.agent.Logger;
import java.io.File;
import java.net.URL;
import java.util.function.Consumer;
import java.util.function.Function;

public class JarAnalystFactory {
    private final Function<URL, JarData> processor;
    private final Consumer<JarData> analyzedJars;
    private final Logger logger;

    public JarAnalystFactory(Function<URL, JarData> processor, Consumer<JarData> analyzedJars, Logger logger) {
        this.processor = processor;
        this.analyzedJars = analyzedJars;
        this.logger = logger;
    }

    public Runnable createWeavePackageAnalyzer(File file) {
        return new WeavePackageAnalyzer(file, this.analyzedJars, this.logger);
    }

    public Runnable createURLAnalyzer(URL url) {
        return new URLAnalyzer(url, this.processor, this.analyzedJars, this.logger);
    }
}

