/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.jfr.daemon;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class VersionFinder {
    private static final String UNKNOWN_VERSION = "UNKNOWN-VERSION";

    private VersionFinder() {
    }

    public static String getVersion() {
        ClassLoader classLoader = VersionFinder.class.getClassLoader();
        if (!(classLoader instanceof URLClassLoader)) {
            return UNKNOWN_VERSION;
        }
        URLClassLoader cl = (URLClassLoader)classLoader;
        URL url = cl.findResource("META-INF/MANIFEST.MF");
        if (url == null) {
            return UNKNOWN_VERSION;
        }
        String result = VersionFinder.readManifest(url);
        return result == null ? UNKNOWN_VERSION : result;
    }

    private static String readManifest(URL url) {
        try {
            Manifest manifest = new Manifest(url.openStream());
            Attributes attributes = manifest.getMainAttributes();
            return attributes.getValue("Implementation-Version");
        }
        catch (IOException e) {
            return UNKNOWN_VERSION;
        }
    }
}

