/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.service.analytics;

import com.newrelic.agent.config.DistributedTracingConfig;
import com.newrelic.agent.deps.com.google.common.annotations.VisibleForTesting;
import com.newrelic.agent.deps.org.json.simple.JSONArray;
import com.newrelic.agent.deps.org.json.simple.JSONObject;
import com.newrelic.agent.deps.org.json.simple.JSONStreamAware;
import com.newrelic.agent.model.AnalyticsEvent;
import com.newrelic.agent.model.ApdexPerfZone;
import com.newrelic.agent.model.PathHashes;
import com.newrelic.agent.model.SyntheticsIds;
import com.newrelic.agent.model.SyntheticsInfo;
import com.newrelic.agent.model.TimeoutCause;
import com.newrelic.agent.model.TransactionTiming;
import com.newrelic.agent.service.ServiceFactory;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class TransactionEvent
extends AnalyticsEvent
implements JSONStreamAware {
    static final float UNASSIGNED_FLOAT = Float.NEGATIVE_INFINITY;
    static final int UNASSIGNED_INT = Integer.MIN_VALUE;
    static final String TYPE = "Transaction";
    private final String appName;
    private final String guid;
    private final String referrerGuid;
    private final String tripId;
    private final PathHashes pathHashes;
    private final ApdexPerfZone apdexPerfZone;
    private final SyntheticsIds syntheticsIds;
    private final SyntheticsInfo syntheticsInfo;
    private final TransactionTiming timing;
    private final int port;
    private final boolean error;
    private final String name;
    private final TimeoutCause timeoutCause;
    private final Map<String, Object> distributedTraceIntrinsics;
    Map<String, Object> agentAttributes;

    public TransactionEvent(String appName, Map<String, Object> userAttributes, long timestamp, String name, TransactionTiming timing, String guid, String referringGuid, Integer port, String tripId, PathHashes pathHashes, ApdexPerfZone apdexPerfZone, SyntheticsIds syntheticsIds, SyntheticsInfo syntheticsInfo, boolean error, TimeoutCause timeoutCause, float priority, Map<String, Object> distributedTraceIntrinsics) {
        super(TYPE, timestamp, priority, userAttributes);
        if (pathHashes == null) {
            throw new NullPointerException("pathHashes must not be null");
        }
        if (syntheticsIds == null) {
            throw new NullPointerException("syntheticsIds must not be null");
        }
        if (syntheticsInfo == null) {
            throw new NullPointerException("syntheticsInfo must not be null");
        }
        if (timing == null) {
            throw new NullPointerException("timing must not be null");
        }
        this.name = name;
        this.timing = timing;
        this.guid = guid;
        this.referrerGuid = referringGuid;
        this.tripId = tripId;
        this.pathHashes = pathHashes;
        this.port = port == null ? Integer.MIN_VALUE : port;
        this.appName = appName;
        this.apdexPerfZone = apdexPerfZone;
        this.syntheticsIds = syntheticsIds;
        this.syntheticsInfo = syntheticsInfo;
        this.error = error;
        this.timeoutCause = timeoutCause;
        this.distributedTraceIntrinsics = distributedTraceIntrinsics;
    }

    public float getDuration() {
        return this.timing.getDuration();
    }

    public float getTotalTime() {
        return this.timing.getTotalTime();
    }

    public float getTTFB() {
        return this.timing.getTimeToFirstByte();
    }

    public float getTTLB() {
        return this.timing.getTimeToLastByte();
    }

    public int getPort() {
        return this.port;
    }

    public String getName() {
        return this.name;
    }

    public float getExternalCallCount() {
        return this.timing.getExternalCallCount();
    }

    public float getExternalDuration() {
        return this.timing.getExternalDuration();
    }

    public float getDatabaseCallCount() {
        return this.timing.getDatabaseCallCount();
    }

    public float getDatabaseDuration() {
        return this.timing.getDatabaseDuration();
    }

    public boolean isError() {
        return this.error;
    }

    public String getGuid() {
        return this.guid;
    }

    public String getTripId() {
        return this.tripId;
    }

    public Integer getPathHash() {
        return this.pathHashes.getPathHash();
    }

    public String getAlternatePathHashes() {
        return this.pathHashes.getAlternatePathHashes();
    }

    public Integer getReferringPathHash() {
        return this.pathHashes.getReferringPathHash();
    }

    public String getReferrerGuid() {
        return this.referrerGuid;
    }

    public String getApdexPerfZone() {
        if (this.apdexPerfZone != null) {
            return this.apdexPerfZone.getZone();
        }
        return null;
    }

    public TimeoutCause getTimeoutCause() {
        return this.timeoutCause;
    }

    @VisibleForTesting
    public Map<String, Object> getDistributedTraceIntrinsics() {
        return this.distributedTraceIntrinsics;
    }

    @VisibleForTesting
    public String getParentId() {
        return this.distributedTraceIntrinsics == null ? null : (String)this.distributedTraceIntrinsics.get("parentId");
    }

    @VisibleForTesting
    public String getParenSpanId() {
        return this.distributedTraceIntrinsics == null ? null : (String)this.distributedTraceIntrinsics.get("parentSpanId");
    }

    @Override
    public void writeJSONString(Writer out) throws IOException {
        DistributedTracingConfig distributedTracingConfig;
        JSONObject obj = new JSONObject();
        obj.put("type", this.getType());
        obj.put("timestamp", this.getTimestamp());
        obj.put("name", this.name);
        obj.put("duration", Float.valueOf(this.timing.getDuration()));
        obj.put("error", this.error);
        obj.put("totalTime", Float.valueOf(this.timing.getTotalTime()));
        obj.put("priority", Float.valueOf(this.getPriority()));
        if (this.timing.getTimeToFirstByte() != Float.NEGATIVE_INFINITY) {
            obj.put("timeToFirstByte", Float.valueOf(this.timing.getTimeToFirstByte()));
        }
        if (this.timing.getTimeToLastByte() != Float.NEGATIVE_INFINITY) {
            obj.put("timeToLastByte", Float.valueOf(this.timing.getTimeToLastByte()));
        }
        if (this.apdexPerfZone != null) {
            obj.put("apdexPerfZone", this.apdexPerfZone.getZone());
        }
        if (!(distributedTracingConfig = ServiceFactory.getConfigService().getDefaultAgentConfig().getDistributedTracingConfig()).isEnabled()) {
            if (this.tripId != null) {
                obj.put("nr.tripId", this.tripId);
            }
            if (this.guid != null) {
                obj.put("nr.guid", this.guid);
            }
            if (this.getPathHash() != null) {
                obj.put("nr.pathHash", String.format("%08x", this.getPathHash()));
            }
            if (this.getReferringPathHash() != null) {
                obj.put("nr.referringPathHash", String.format("%08x", this.getReferringPathHash()));
            }
            if (this.getAlternatePathHashes() != null) {
                obj.put("nr.alternatePathHashes", this.getAlternatePathHashes());
            }
            if (this.referrerGuid != null) {
                obj.put("nr.referringTransactionGuid", this.referrerGuid);
            }
        }
        if (this.syntheticsIds.getResourceId() != null) {
            obj.put("nr.syntheticsResourceId", this.syntheticsIds.getResourceId());
        }
        if (this.syntheticsIds.getMonitorId() != null) {
            obj.put("nr.syntheticsMonitorId", this.syntheticsIds.getMonitorId());
        }
        if (this.syntheticsIds.getJobId() != null) {
            obj.put("nr.syntheticsJobId", this.syntheticsIds.getJobId());
        }
        if (this.syntheticsInfo.getType() != null) {
            obj.put("nr.syntheticsType", this.syntheticsInfo.getType());
        }
        if (this.syntheticsInfo.getInitiator() != null) {
            obj.put("nr.syntheticsInitiator", this.syntheticsInfo.getInitiator());
        }
        if (this.syntheticsInfo.getAttributeMap() != null) {
            Map<String, String> attrMap = this.syntheticsInfo.getAttributeMap();
            for (String key : attrMap.keySet()) {
                String upperCaseKey = Character.toUpperCase(key.charAt(0)) + key.substring(1);
                String attrName = String.format("nr.synthetics%s", upperCaseKey);
                obj.put(attrName, attrMap.get(key));
            }
        }
        if (this.port != Integer.MIN_VALUE) {
            obj.put("port", this.port);
        }
        if (this.timing.getQueueDuration() != Float.NEGATIVE_INFINITY) {
            obj.put("queueDuration", Float.valueOf(this.timing.getQueueDuration()));
        }
        if (this.getExternalDuration() != Float.NEGATIVE_INFINITY) {
            obj.put("externalDuration", Float.valueOf(this.getExternalDuration()));
        }
        if (this.getExternalCallCount() > 0.0f) {
            obj.put("externalCallCount", Float.valueOf(this.getExternalCallCount()));
        }
        if (this.getDatabaseDuration() != Float.NEGATIVE_INFINITY) {
            obj.put("databaseDuration", Float.valueOf(this.getDatabaseDuration()));
        }
        if (this.getDatabaseCallCount() > 0.0f) {
            obj.put("databaseCallCount", Float.valueOf(this.getDatabaseCallCount()));
        }
        if (this.timing.getGcCumulative() != Float.NEGATIVE_INFINITY) {
            obj.put("gcCumulative", Float.valueOf(this.timing.getGcCumulative()));
        }
        if (this.timeoutCause != null) {
            obj.put("nr.timeoutCause", this.timeoutCause.cause);
        }
        if (this.distributedTraceIntrinsics != null && !this.distributedTraceIntrinsics.isEmpty()) {
            obj.putAll(this.distributedTraceIntrinsics);
        }
        Map<String, ?> filteredUserAtts = this.getUserFilteredMap(this.getMutableUserAttributes());
        Map<String, ?> filteredAgentAtts = this.getFilteredMap(this.agentAttributes);
        if (filteredAgentAtts.isEmpty()) {
            if (filteredUserAtts.isEmpty()) {
                JSONArray.writeJSONString(Collections.singletonList(obj), out);
            } else {
                JSONArray.writeJSONString(Arrays.asList(obj, filteredUserAtts), out);
            }
        } else {
            JSONArray.writeJSONString(Arrays.asList(obj, filteredUserAtts, filteredAgentAtts), out);
        }
    }

    private Map<String, ?> getFilteredMap(Map<String, ?> input) {
        return ServiceFactory.getAttributesService().filterTransactionEventAttributes(this.appName, input);
    }

    private Map<String, ?> getUserFilteredMap(Map<String, ?> input) {
        if (!ServiceFactory.getConfigService().getDefaultAgentConfig().isHighSecurity()) {
            return this.getFilteredMap(input);
        }
        return Collections.emptyMap();
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @VisibleForTesting
    public Map<String, Object> getAgentAttributesCopy() {
        return new HashMap<String, Object>(this.agentAttributes);
    }

    public String getSyntheticsJobId() {
        return this.syntheticsIds.getJobId();
    }
}

