/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.telemetry.util;

import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;

public class Utils {
    public static <E> E verifyNonNull(E input, String message) throws IllegalArgumentException {
        if (input == null) {
            throw new IllegalArgumentException(message);
        }
        return input;
    }

    public static String verifyNonBlank(String input, String message) throws IllegalArgumentException {
        if (input == null || input.isEmpty()) {
            throw new IllegalArgumentException(message);
        }
        return input;
    }

    public static <E> E verifyNonNull(E input) throws IllegalArgumentException {
        return Utils.verifyNonNull(input, "input cannot be null");
    }

    public static UUID generateUUID() {
        int i;
        byte[] randomBytes = new byte[16];
        ThreadLocalRandom.current().nextBytes(randomBytes);
        randomBytes[6] = (byte)(randomBytes[6] & 0xF);
        randomBytes[6] = (byte)(randomBytes[6] | 0x40);
        randomBytes[8] = (byte)(randomBytes[8] & 0x3F);
        randomBytes[8] = (byte)(randomBytes[8] | 0x80);
        long msb = 0L;
        long lsb = 0L;
        for (i = 0; i < 8; ++i) {
            msb = msb << 8 | (long)(randomBytes[i] & 0xFF);
        }
        for (i = 8; i < 16; ++i) {
            lsb = lsb << 8 | (long)(randomBytes[i] & 0xFF);
        }
        return new UUID(msb, lsb);
    }
}

