/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.api.agent;

import com.newrelic.api.agent.HeaderType;
import com.newrelic.api.agent.Headers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ConcurrentHashMapHeaders
implements Headers {
    private final HeaderType headerType;
    private final Map<String, List<String>> headers;

    private ConcurrentHashMapHeaders(HeaderType headerType) {
        this.headerType = headerType;
        this.headers = new ConcurrentHashMap<String, List<String>>();
    }

    public Map<String, List<String>> getMapCopy() {
        return new HashMap<String, List<String>>(this.headers);
    }

    public void removeHeader(String name) {
        this.headers.remove(name);
    }

    @Override
    public HeaderType getHeaderType() {
        return this.headerType;
    }

    @Override
    public String getHeader(String name) {
        List<String> values = this.headers.get(name);
        return values == null || values.size() == 0 ? null : values.get(0);
    }

    @Override
    public Collection<String> getHeaders(String name) {
        List<String> values = this.headers.get(name);
        return values == null ? Collections.emptyList() : Collections.unmodifiableList(values);
    }

    @Override
    public void setHeader(String name, String value) {
        ArrayList<String> values = new ArrayList<String>();
        values.add(value);
        this.headers.put(name, values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addHeader(String name, String value) {
        Map<String, List<String>> map = this.headers;
        synchronized (map) {
            List<String> values = this.headers.get(name);
            if (values == null) {
                this.setHeader(name, value);
            } else {
                values.add(value);
            }
        }
    }

    @Override
    public Collection<String> getHeaderNames() {
        return new HashSet<String>(this.headers.keySet());
    }

    @Override
    public boolean containsHeader(String name) {
        return this.headers.containsKey(name);
    }

    public static ConcurrentHashMapHeaders build(HeaderType headerType) {
        return new ConcurrentHashMapHeaders(headerType);
    }

    public static ConcurrentHashMapHeaders buildFromFlatMap(HeaderType headerType, Map<String, String> map) {
        ConcurrentHashMapHeaders headers = ConcurrentHashMapHeaders.build(headerType);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            headers.setHeader(entry.getKey(), entry.getValue());
        }
        return headers;
    }

    public static ConcurrentHashMapHeaders buildFromMap(HeaderType headerType, Map<String, List<String>> map) {
        ConcurrentHashMapHeaders headers = ConcurrentHashMapHeaders.build(headerType);
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            for (String value : entry.getValue()) {
                headers.addHeader(entry.getKey(), value);
            }
        }
        return headers;
    }
}

