/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation;

import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.SecurityAgentConfig;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.logging.IAgentLogger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class ClassNameFilter {
    private static final String EXCLUDES_FILE = "/META-INF/excludes";
    private final List<Pattern> excludePatterns = new LinkedList<Pattern>();
    private final List<Pattern> includePatterns = new LinkedList<Pattern>();
    private volatile Set<String> includeClasses = new HashSet<String>();
    private final IAgentLogger logger;

    public ClassNameFilter(IAgentLogger logger) {
        this.logger = logger;
    }

    public boolean isExcluded(String className) {
        for (Pattern pattern : this.excludePatterns) {
            if (!pattern.matcher(className).matches()) continue;
            return true;
        }
        return false;
    }

    public boolean isIncluded(String className) {
        if (this.includeClasses.contains(className)) {
            return true;
        }
        for (Pattern pattern : this.includePatterns) {
            if (!pattern.matcher(className).matches()) continue;
            return true;
        }
        return false;
    }

    public void addConfigClassFilters(AgentConfig config) {
        Set<String> excludes = config.getClassTransformerConfig().getExcludes();
        if (excludes.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("Exclude class name filters:");
            for (String exclude : excludes) {
                sb.append("\n").append(exclude);
                this.addExclude(exclude);
                if (!SecurityAgentConfig.SECURITY_AGENT_CLASS_TRANSFORMER_EXCLUDES_TO_IGNORE.contains(exclude)) continue;
                this.logger.finer(exclude + " class_transformer exclude explicitly added by user config. The user configured exclude rule will take precedence and will not be ignored due to the security agent being enabled.");
            }
            this.logger.finer(sb.toString());
        }
        Set<String> includes = config.getClassTransformerConfig().getIncludes();
        for (String include : includes) {
            this.addInclude(include);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExcludeFileClassFilters() {
        InputStream iStream = this.getClass().getResourceAsStream(EXCLUDES_FILE);
        BufferedReader reader = new BufferedReader(new InputStreamReader(iStream));
        LinkedList<String> excludeList = new LinkedList<String>();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#")) continue;
                excludeList.add(line);
            }
        }
        catch (IOException ex) {
            this.logger.severe(MessageFormat.format("Unable to read the class excludes file at {0} found within the New Relic jar.", EXCLUDES_FILE));
        }
        finally {
            try {
                iStream.close();
            }
            catch (IOException ex) {}
        }
        boolean ignoreExcludeForSecurityAgent = false;
        String formattedIgnoredExcludes = String.join((CharSequence)",", SecurityAgentConfig.SECURITY_AGENT_CLASS_TRANSFORMER_EXCLUDES_TO_IGNORE);
        boolean shouldInitializeSecurityAgent = SecurityAgentConfig.shouldInitializeSecurityAgent();
        for (String exclude : excludeList) {
            boolean bl = ignoreExcludeForSecurityAgent = shouldInitializeSecurityAgent && SecurityAgentConfig.SECURITY_AGENT_CLASS_TRANSFORMER_EXCLUDES_TO_IGNORE.contains(exclude);
            if (ignoreExcludeForSecurityAgent) {
                this.logger.finer("Ignored " + exclude + " class_transformer exclude defined in META-INF/excludes because the security agent is enabled. This can be overridden by explicitly setting newrelic.config.class_transformer.excludes=" + formattedIgnoredExcludes + " or NEW_RELIC_CLASS_TRANSFORMER_EXCLUDES=" + formattedIgnoredExcludes);
                continue;
            }
            this.addExclude(exclude);
        }
        if (ignoreExcludeForSecurityAgent) {
            for (String exclude : SecurityAgentConfig.SECURITY_AGENT_CLASS_TRANSFORMER_EXCLUDES_TO_IGNORE) {
                excludeList.remove(exclude);
            }
        }
        this.logger.finer("Excludes initialized: " + excludeList);
    }

    public void addInclude(String include) {
        if (this.isRegex(include)) {
            this.addIncludeRegex(include);
        } else {
            this.addIncludeClass(include);
        }
    }

    public void addIncludeClass(String className) {
        String regex = this.classNameToRegex(className);
        this.addIncludeRegex(regex);
    }

    public void addIncludeRegex(String regex) {
        Pattern pattern = this.regexToPattern(regex);
        if (pattern != null) {
            this.includePatterns.add(pattern);
        }
    }

    public void addExclude(String exclude) {
        if (this.isRegex(exclude)) {
            this.addExcludeRegex(exclude);
        } else {
            this.addExcludeClass(exclude);
        }
    }

    public void addExcludeClass(String className) {
        String regex = this.classNameToRegex(className);
        this.addExcludeRegex(regex);
    }

    public void addExcludeRegex(String regex) {
        Pattern pattern = this.regexToPattern(regex);
        if (pattern != null) {
            this.excludePatterns.add(pattern);
        }
    }

    private String classNameToRegex(String className) {
        return "^" + className.replace("$", "\\$") + "$";
    }

    private Pattern regexToPattern(String regex) {
        try {
            return Pattern.compile(regex);
        }
        catch (Exception e) {
            this.logger.severe(MessageFormat.format("Unable to compile pattern: {0}", regex));
            return null;
        }
    }

    private boolean isRegex(String value) {
        return value.indexOf(42) >= 0 || value.indexOf(124) >= 0 || value.indexOf(94) >= 0;
    }

    public void addClassMatcherIncludes(Collection<ClassMatcher> classMatchers) {
        HashSet<String> classNames = new HashSet<String>();
        classNames.addAll(this.includeClasses);
        for (ClassMatcher classMatcher : classMatchers) {
            for (String className : classMatcher.getClassNames()) {
                classNames.add(className);
            }
        }
        this.logger.finer("Class name inclusions: " + classNames);
        this.includeClasses = classNames;
    }
}

