/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.deps.jregex;

import com.newrelic.agent.deps.jregex.Bitset;
import com.newrelic.agent.deps.jregex.UnicodeConstants;

class Block
implements UnicodeConstants {
    private boolean isFull;
    boolean[] bits;
    private boolean shared = false;
    private static final boolean[] EMPTY_BITS = new boolean[256];
    private static final boolean[] FULL_BITS = new boolean[256];

    Block() {
    }

    Block(boolean[] bits) {
        this.bits = bits;
        this.shared = true;
    }

    final boolean set(int c) {
        if (this.isFull) {
            return false;
        }
        boolean[] bits = this.bits;
        if (bits == null) {
            this.bits = bits = new boolean[256];
            this.shared = false;
            bits[c] = true;
            return true;
        }
        if (bits[c]) {
            return false;
        }
        if (this.shared) {
            bits = Block.copyBits(this);
        }
        bits[c] = true;
        return true;
    }

    final boolean get(int c) {
        if (this.isFull) {
            return true;
        }
        boolean[] bits = this.bits;
        if (bits == null) {
            return false;
        }
        return bits[c];
    }

    static final int add(Block[] targets, Block[] addends, int from, int to, boolean inv) {
        int s2 = 0;
        for (int i = from; i <= to; ++i) {
            Block addend = addends[i];
            if (addend != null ? addend.isFull && inv : !inv) continue;
            Block target = targets[i];
            if (target == null) {
                targets[i] = target = new Block();
            } else if (target.isFull) continue;
            s2 += Block.add(target, addend, inv);
        }
        return s2;
    }

    private static final int add(Block target, Block addend, boolean inv) {
        if (addend == null) {
            if (!inv) {
                return 0;
            }
            int s2 = 256;
            boolean[] targetbits = target.bits;
            if (target.bits != null) {
                s2 -= Block.count(targetbits, 0, 255);
            }
            target.isFull = true;
            target.bits = null;
            target.shared = false;
            return s2;
        }
        if (addend.isFull) {
            if (inv) {
                return 0;
            }
            int s3 = 256;
            boolean[] targetbits = target.bits;
            if (target.bits != null) {
                s3 -= Block.count(targetbits, 0, 255);
            }
            target.isFull = true;
            target.bits = null;
            target.shared = false;
            return s3;
        }
        boolean[] addbits = addend.bits;
        if (addend.bits == null) {
            if (!inv) {
                return 0;
            }
            int s4 = 256;
            boolean[] targetbits = target.bits;
            if (target.bits != null) {
                s4 -= Block.count(targetbits, 0, 255);
            }
            target.isFull = true;
            target.bits = null;
            target.shared = false;
            return s4;
        }
        boolean[] targetbits = target.bits;
        if (target.bits == null) {
            if (!inv) {
                target.bits = addbits;
                target.shared = true;
                return Block.count(addbits, 0, 255);
            }
            target.bits = targetbits = Block.emptyBits(null);
            target.shared = false;
            return Bitset.add(targetbits, addbits, 0, 255, inv);
        }
        if (target.shared) {
            targetbits = Block.copyBits(target);
        }
        return Bitset.add(targetbits, addbits, 0, 255, inv);
    }

    static final int subtract(Block[] targets, Block[] subtrahends, int from, int to, boolean inv) {
        int s2 = 0;
        for (int i = from; i <= to; ++i) {
            Block target = targets[i];
            if (target == null || !target.isFull && target.bits == null) continue;
            Block subtrahend = subtrahends[i];
            if (subtrahend == null) {
                if (!inv) continue;
                s2 = target.isFull ? (s2 -= 256) : (s2 -= Block.count(target.bits, 0, 255));
                target.isFull = false;
                target.bits = null;
                target.shared = false;
                continue;
            }
            s2 += Block.subtract(target, subtrahend, inv);
        }
        return s2;
    }

    private static final int subtract(Block target, Block subtrahend, boolean inv) {
        if (subtrahend.isFull) {
            if (inv) {
                return 0;
            }
            int s2 = 0;
            s2 = target.isFull ? 256 : Block.count(target.bits, 0, 255);
            target.isFull = false;
            target.bits = null;
            target.shared = false;
            return s2;
        }
        boolean[] subbits = subtrahend.bits;
        if (subtrahend.bits == null) {
            if (!inv) {
                return 0;
            }
            int s3 = 0;
            s3 = target.isFull ? 256 : Block.count(target.bits, 0, 255);
            target.isFull = false;
            target.bits = null;
            target.shared = false;
            return s3;
        }
        if (target.isFull) {
            boolean[] bits = Block.fullBits(target.bits);
            int s4 = Bitset.subtract(bits, subbits, 0, 255, inv);
            target.isFull = false;
            target.shared = false;
            target.bits = bits;
            return s4;
        }
        boolean[] targetbits = target.shared ? Block.copyBits(target) : target.bits;
        return Bitset.subtract(targetbits, subbits, 0, 255, inv);
    }

    private static boolean[] copyBits(Block block) {
        boolean[] bits = new boolean[256];
        System.arraycopy(block.bits, 0, bits, 0, 256);
        block.bits = bits;
        block.shared = false;
        return bits;
    }

    private static boolean[] fullBits(boolean[] bits) {
        if (bits == null) {
            bits = new boolean[256];
        }
        System.arraycopy(FULL_BITS, 0, bits, 0, 256);
        return bits;
    }

    private static boolean[] emptyBits(boolean[] bits) {
        if (bits == null) {
            bits = new boolean[256];
        } else {
            System.arraycopy(EMPTY_BITS, 0, bits, 0, 256);
        }
        return bits;
    }

    static final int count(boolean[] arr, int from, int to) {
        int s2 = 0;
        for (int i = from; i <= to; ++i) {
            if (!arr[i]) continue;
            ++s2;
        }
        return s2;
    }

    static final boolean[][] toBitset2(Block[] blocks) {
        int len = blocks.length;
        boolean[][] result = new boolean[len][];
        for (int i = 0; i < len; ++i) {
            Block block = blocks[i];
            if (block == null) continue;
            result[i] = block.isFull ? FULL_BITS : block.bits;
        }
        return result;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            Block.FULL_BITS[i] = true;
        }
    }
}

