/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.weave.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;

public final class JarUtils {
    private static final String NEWRELIC_TEMPDIR = "newrelic.tempdir";

    private JarUtils() {
    }

    public static File createJarFile(String prefix, Map<String, byte[]> classes) throws IOException {
        return JarUtils.createJarFile(prefix, classes, null);
    }

    public static File createJarFile(String prefix, Map<String, byte[]> classes, Manifest manifest) throws IOException {
        return JarUtils.createJarFile(prefix, classes, manifest, null);
    }

    public static File createJarFile(String prefix, Map<String, byte[]> classes, Manifest manifest, Map<String, byte[]> extensions) throws IOException {
        File file = File.createTempFile(prefix, ".jar", JarUtils.getTempDir());
        file.deleteOnExit();
        if (manifest == null) {
            manifest = new Manifest();
        }
        JarOutputStream outStream = new JarOutputStream((OutputStream)new FileOutputStream(file), manifest);
        JarUtils.writeFilesToJarStream(classes, outStream, extensions);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeFilesToJarStream(Map<String, byte[]> classes, JarOutputStream outStream, Map<String, byte[]> extensions) throws IOException {
        HashMap<String, byte[]> resources = new HashMap<String, byte[]>();
        for (Map.Entry<String, byte[]> entry : classes.entrySet()) {
            resources.put(entry.getKey().replace('.', '/') + ".class", entry.getValue());
        }
        try {
            JarUtils.addJarEntries(outStream, resources);
            JarUtils.addExtensions(outStream, extensions);
        }
        finally {
            try {
                outStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static void addJarEntries(JarOutputStream jarStream, Map<String, byte[]> files) throws IOException {
        for (Map.Entry<String, byte[]> entry : files.entrySet()) {
            JarEntry jarEntry = new JarEntry(entry.getKey());
            jarStream.putNextEntry(jarEntry);
            jarStream.write(entry.getValue());
            jarStream.closeEntry();
        }
    }

    private static void addExtensions(JarOutputStream jarStream, Map<String, byte[]> extensions) throws IOException {
        if (extensions == null) {
            return;
        }
        JarEntry extensionsEntry = new JarEntry("META-INF/extensions/extensions");
        jarStream.putNextEntry(extensionsEntry);
        for (Map.Entry<String, byte[]> entry : extensions.entrySet()) {
            jarStream.write(entry.getKey().getBytes());
            jarStream.write("\r\n".getBytes());
        }
        jarStream.closeEntry();
        for (Map.Entry<String, byte[]> entry : extensions.entrySet()) {
            JarEntry jarEntry = new JarEntry("META-INF/extensions/" + entry.getKey());
            jarStream.putNextEntry(jarEntry);
            jarStream.write(entry.getValue());
            jarStream.closeEntry();
        }
    }

    private static File getTempDir() {
        File tempDirFile;
        String tempDir = System.getProperty(NEWRELIC_TEMPDIR);
        if (null != tempDir && (tempDirFile = new File(tempDir)).exists()) {
            return tempDirFile;
        }
        return null;
    }
}

