/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.trace;

import com.newrelic.agent.HarvestListener;
import com.newrelic.agent.IRPMService;
import com.newrelic.agent.IgnoreSilentlyException;
import com.newrelic.agent.TransactionData;
import com.newrelic.agent.TransactionListener;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.ConfigService;
import com.newrelic.agent.profile.v2.TransactionProfileService;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.stats.StatsEngine;
import com.newrelic.agent.stats.TransactionStats;
import com.newrelic.agent.trace.ITransactionSampler;
import com.newrelic.agent.trace.KeyTransactionTraceSampler;
import com.newrelic.agent.trace.RandomTransactionSampler;
import com.newrelic.agent.trace.SyntheticsTransactionSampler;
import com.newrelic.agent.trace.TransactionTrace;
import com.newrelic.agent.trace.TransactionTraceSampler;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;

public class TransactionTraceService
extends AbstractService
implements HarvestListener,
TransactionListener {
    private static final int INITIAL_TRACE_LIMIT = 5;
    private final ThreadMXBean threadMXBean;
    private final boolean autoAppNameEnabled;
    private final boolean threadCpuTimeEnabled;
    private final ConfigService configService;
    private final ConcurrentMap<String, ITransactionSampler> namedSamplers;
    final List<ITransactionSampler> transactionSamplers = new CopyOnWriteArrayList<ITransactionSampler>();
    private final SyntheticsTransactionSampler syntheticsTransactionSampler;
    private volatile TransactionProfileService transactionProfileService;

    public TransactionTraceService() {
        super(TransactionTraceService.class.getSimpleName());
        this.namedSamplers = new ConcurrentHashMap<String, ITransactionSampler>();
        this.namedSamplers.put("request", this.createSampler());
        this.namedSamplers.put("background", this.createSampler());
        this.addTransactionTraceSampler(new KeyTransactionTraceSampler());
        this.threadMXBean = ManagementFactory.getThreadMXBean();
        this.configService = ServiceFactory.getConfigService();
        AgentConfig config = this.configService.getDefaultAgentConfig();
        this.autoAppNameEnabled = config.isAutoAppNamingEnabled();
        this.threadCpuTimeEnabled = this.initThreadCPUEnabled(config);
        this.syntheticsTransactionSampler = new SyntheticsTransactionSampler();
    }

    public ThreadMXBean getThreadMXBean() {
        return this.threadMXBean;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    public void addTransactionTraceSampler(ITransactionSampler transactionSampler) {
        this.transactionSamplers.add(transactionSampler);
    }

    public void removeTransactionTraceSampler(ITransactionSampler transactionSampler) {
        this.transactionSamplers.remove(transactionSampler);
    }

    public boolean isThreadCpuTimeEnabled() {
        return this.threadCpuTimeEnabled || this.isProfileSessionActive();
    }

    private boolean isProfileSessionActive() {
        if (this.transactionProfileService == null) {
            return false;
        }
        return this.transactionProfileService.isTransactionProfileSessionActive() && this.threadMXBean.isCurrentThreadCpuTimeSupported();
    }

    private boolean initThreadCPUEnabled(AgentConfig config) {
        Boolean prop = config.getProperty("thread_cpu_time_enabled", false);
        if (prop == null || !prop.booleanValue()) {
            return false;
        }
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        return threadMXBean.isThreadCpuTimeSupported() && threadMXBean.isThreadCpuTimeEnabled();
    }

    private ITransactionSampler getOrCreateNamedSampler(TransactionData transactionData) {
        String samplerName = this.autoAppNameEnabled ? transactionData.getApplicationName() : (transactionData.getDispatcher().isWebTransaction() ? "request" : "background");
        ITransactionSampler sampler = (ITransactionSampler)this.namedSamplers.get(samplerName);
        if (sampler == null) {
            sampler = this.createSampler();
            ITransactionSampler existingSampler = this.namedSamplers.putIfAbsent(transactionData.getApplicationName(), sampler);
            if (existingSampler != null) {
                return existingSampler;
            }
        }
        return sampler;
    }

    private void noticeTransaction(TransactionData transactionData) {
        if (this.syntheticsTransactionSampler.noticeTransaction(transactionData)) {
            return;
        }
        for (ITransactionSampler transactionSampler : this.transactionSamplers) {
            if (!transactionSampler.noticeTransaction(transactionData)) continue;
            return;
        }
        ITransactionSampler sampler = this.getOrCreateNamedSampler(transactionData);
        if (sampler != null) {
            sampler.noticeTransaction(transactionData);
        }
    }

    @Override
    public void beforeHarvest(String appName, StatsEngine statsEngine) {
    }

    @Override
    public void afterHarvest(String appName) {
        ArrayList<TransactionTrace> traces = new ArrayList<TransactionTrace>();
        if (this.autoAppNameEnabled) {
            traces.addAll(this.getNamedSamplerTraces(appName));
        } else {
            traces.addAll(this.getNamedSamplerTraces("request"));
            traces.addAll(this.getNamedSamplerTraces("background"));
        }
        traces.addAll(this.syntheticsTransactionSampler.harvest(appName));
        for (ITransactionSampler transactionSampler : this.transactionSamplers) {
            traces.addAll(transactionSampler.harvest(appName));
        }
        if (!traces.isEmpty()) {
            IRPMService rpmService = ServiceFactory.getRPMServiceManager().getOrCreateRPMService(appName);
            this.sendTraces(rpmService, traces);
        }
    }

    private List<TransactionTrace> getNamedSamplerTraces(String appName) {
        ITransactionSampler sampler = (ITransactionSampler)this.namedSamplers.get(appName);
        if (sampler != null) {
            return sampler.harvest(appName);
        }
        return Collections.emptyList();
    }

    private void sendTraces(IRPMService rpmService, List<TransactionTrace> traces) {
        if (!rpmService.isConnected()) {
            return;
        }
        try {
            rpmService.sendTransactionTraceData(traces);
        }
        catch (IgnoreSilentlyException ignoreSilentlyException) {
        }
        catch (Exception e) {
            if (this.getLogger().isLoggable(Level.FINEST)) {
                this.getLogger().log(Level.FINEST, e, "Error sending transaction trace data to {0} for {1}: {2}", rpmService.getHostString(), rpmService.getApplicationName(), e.getMessage());
            }
            this.getLogger().log(Level.FINE, "Error sending transaction trace data to {0} for {1}: {2}", rpmService.getHostString(), rpmService.getApplicationName(), e.getMessage());
        }
    }

    @Override
    protected void doStart() {
        ServiceFactory.getTransactionService().addTransactionListener(this);
        ServiceFactory.getHarvestService().addHarvestListener(this);
        this.transactionProfileService = ServiceFactory.getProfilerService().getTransactionProfileService();
        RandomTransactionSampler.startSampler(5);
    }

    @Override
    protected void doStop() {
        this.syntheticsTransactionSampler.stop();
        for (ITransactionSampler sampler : this.transactionSamplers) {
            sampler.stop();
        }
        this.transactionSamplers.clear();
        for (ITransactionSampler sampler : this.namedSamplers.values()) {
            sampler.stop();
        }
        this.namedSamplers.clear();
    }

    private ITransactionSampler createSampler() {
        return new TransactionTraceSampler();
    }

    @Override
    public void dispatcherTransactionFinished(TransactionData transactionData, TransactionStats transactionStats) {
        if (!transactionData.getTransactionTracerConfig().isEnabled()) {
            return;
        }
        this.noticeTransaction(transactionData);
    }
}

