/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.Agent;
import com.newrelic.agent.config.AgentControlIntegrationConfig;
import com.newrelic.agent.config.AgentControlIntegrationHealthConfig;
import com.newrelic.agent.config.BaseConfig;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;

public class AgentControlIntegrationConfigImpl
extends BaseConfig
implements AgentControlIntegrationConfig {
    public static final String ROOT = "agent_control";
    public static final String SYSTEM_PROPERTY_ROOT = "newrelic.config.agent_control.";
    public static final String ENABLED = "enabled";
    private boolean enabled = this.getProperty("enabled", false);
    public static final boolean ENABLED_DEFAULT = false;
    private AgentControlIntegrationHealthConfig agentControlIntegrationHealthConfig;

    public AgentControlIntegrationConfigImpl(Map<String, Object> configProps) {
        super(configProps, SYSTEM_PROPERTY_ROOT);
        if (this.enabled) {
            this.agentControlIntegrationHealthConfig = this.createHealthConfig();
            if (this.agentControlIntegrationHealthConfig.getHealthDeliveryLocation() == null) {
                Agent.LOG.log(Level.WARNING, "Configured Agent Control health delivery location is not a valid URI; Agent Control integration service will not be started");
                this.enabled = false;
            }
        }
    }

    private AgentControlIntegrationHealthConfig createHealthConfig() {
        Map<String, Object> healthProps = this.getProperty("health", Collections.emptyMap());
        return new AgentControlIntegrationHealthConfig(healthProps, SYSTEM_PROPERTY_ROOT);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public URI getHealthDeliveryLocation() {
        return this.agentControlIntegrationHealthConfig == null ? null : this.agentControlIntegrationHealthConfig.getHealthDeliveryLocation();
    }

    @Override
    public int getHealthReportingFrequency() {
        return this.agentControlIntegrationHealthConfig == null ? 0 : this.agentControlIntegrationHealthConfig.getHealthReportingFrequency();
    }

    @Override
    public String getHealthClientType() {
        return this.agentControlIntegrationHealthConfig == null ? null : this.agentControlIntegrationHealthConfig.getHealthClientType();
    }
}

