/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.weave.verification;

import com.newrelic.weave.utils.ClassCache;
import com.newrelic.weave.utils.ClassLoaderFinder;
import com.newrelic.weave.verification.VerificationClassLoader;
import com.newrelic.weave.violation.WeaveViolation;
import com.newrelic.weave.weavepackage.CachedWeavePackage;
import com.newrelic.weave.weavepackage.PackageValidationResult;
import com.newrelic.weave.weavepackage.WeavePackage;
import com.newrelic.weave.weavepackage.WeavePackageConfig;
import java.io.File;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.jar.JarInputStream;
import java.util.zip.ZipInputStream;

public class WeavePackageVerifier {
    private final PrintStream out;
    private final String instrumentationJar;
    private final List<String> userJars;

    public static void main(String[] args) {
        String instrumentationJar = args[0];
        boolean expectedVerificationResult = Boolean.valueOf(args[1]);
        List<String> userJars = new ArrayList<String>();
        if (args.length > 2) {
            userJars = Arrays.asList(args).subList(2, args.length);
        }
        try {
            boolean passed = WeavePackageVerifier.verify(System.out, instrumentationJar, userJars);
            System.out.println("-- Expected verification result:" + expectedVerificationResult);
            System.out.println("-- Actual verification result:" + passed);
            if (passed == expectedVerificationResult) {
                System.out.println("SUCCEEDED");
            } else {
                System.out.println("FAILED");
                System.exit(1);
            }
        }
        catch (Exception e) {
            System.err.println("Unexpected error while verifying");
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static boolean verify(PrintStream out, String instrumentationJar, List<String> userJars) throws Exception {
        return new WeavePackageVerifier(out, instrumentationJar, userJars).verify();
    }

    private WeavePackageVerifier(PrintStream out, String instrumentationJar, List<String> userJars) {
        this.out = out;
        this.instrumentationJar = instrumentationJar;
        this.userJars = userJars;
    }

    private boolean verify() throws Exception {
        ClassLoader loader;
        ClassCache cache;
        WeavePackage weavePackage = this.getWeavePackage(this.instrumentationJar);
        PackageValidationResult result = weavePackage.validate(cache = new ClassCache(new ClassLoaderFinder(loader = this.createClassloaderForVerification(this.userJars))));
        if (!result.succeeded()) {
            for (WeaveViolation violation : result.getViolations()) {
                this.out.println(violation.toString());
            }
        }
        return result.succeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WeavePackage getWeavePackage(String instrumentationJar) throws Exception {
        URL instrumentationJarUrl = new File(instrumentationJar).toURI().toURL();
        ZipInputStream jarStream = null;
        try {
            WeavePackageConfig config = WeavePackageConfig.builder().url(instrumentationJarUrl).build();
            jarStream = new JarInputStream(instrumentationJarUrl.openStream());
            WeavePackage weavePackage = CachedWeavePackage.createWeavePackage((JarInputStream)jarStream, config);
            return weavePackage;
        }
        finally {
            if (null != jarStream) {
                jarStream.close();
            }
        }
    }

    private ClassLoader createClassloaderForVerification(List<String> jars) throws MalformedURLException {
        HashSet<URL> urls = new HashSet<URL>();
        this.out.println("Creating user classloader with custom classpath:");
        for (String s : jars) {
            File jarFile = new File(s);
            if (!jarFile.exists()) {
                this.out.println(String.format("\tWARNING: Given jar does not exist: %s", s));
            }
            urls.add(jarFile.toURI().toURL());
            this.out.println(String.format("\t%s", s));
        }
        return new VerificationClassLoader(urls.toArray(new URL[urls.size()]));
    }
}

