/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.xray;

import com.newrelic.agent.Agent;
import com.newrelic.agent.IRPMService;
import com.newrelic.agent.commands.AbstractCommand;
import com.newrelic.agent.commands.CommandException;
import com.newrelic.agent.xray.IXRaySessionService;
import com.newrelic.agent.xray.XRaySessionService;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class StartXRayCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "active_xray_sessions";
    private static final String DISABLED_MESSAGE = "The X-Ray service is disabled";
    private IXRaySessionService xRaySessionService;

    public StartXRayCommand(XRaySessionService xRaySessionService) {
        super(COMMAND_NAME);
        this.xRaySessionService = xRaySessionService;
    }

    @Override
    public Map<?, ?> process(IRPMService rpmService, Map arguments) throws CommandException {
        if (this.xRaySessionService.isEnabled()) {
            return this.processEnabled(rpmService, arguments);
        }
        return this.processDisabled(rpmService, arguments);
    }

    private Map processDisabled(IRPMService rpmService, Map arguments) {
        Agent.LOG.debug(DISABLED_MESSAGE);
        try {
            this.xRaySessionService.stop();
        }
        catch (Exception e) {
            Agent.LOG.warning("Error disabling X-Ray Session service: " + e.getMessage());
        }
        return Collections.EMPTY_MAP;
    }

    private Map processEnabled(IRPMService rpmService, Map arguments) {
        Object xray_ids = arguments.remove("xray_ids");
        List xrayIds = xray_ids instanceof List ? (List)xray_ids : Collections.emptyList();
        return this.xRaySessionService.processSessionsList(xrayIds, rpmService);
    }
}

