/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.transaction;

import com.newrelic.agent.Agent;
import com.newrelic.agent.tracers.Tracer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;

public class TransactionTimer {
    private final long startTimeNs;
    private volatile long totalTimeNs;
    private final AtomicLong timeToLastByteNs;
    private final AtomicLong timeToFirstByteNs;
    private volatile long transactionEndTimeNs;
    private final AtomicLong responseTimeNs;
    private volatile long timeLastTxaFinished;

    public TransactionTimer(long startTimeNs) {
        this.startTimeNs = startTimeNs;
        this.timeToLastByteNs = new AtomicLong(0L);
        this.timeToFirstByteNs = new AtomicLong(0L);
        this.responseTimeNs = new AtomicLong(0L);
    }

    public void markTxaFinishTime(Tracer rootTracer) {
        this.timeLastTxaFinished = Math.max(this.timeLastTxaFinished, rootTracer.getEndTime());
    }

    public long getTimeLastTxaFinished() {
        return this.timeLastTxaFinished;
    }

    public boolean markTimeToLastByte(long endTimeNs) {
        long duration = Math.max(0L, endTimeNs - this.startTimeNs);
        return duration > 0L && this.timeToLastByteNs.compareAndSet(0L, duration);
    }

    public boolean markResponseTime(long endTimeNs) {
        if (this.responseTimeNs.compareAndSet(0L, Math.max(0L, endTimeNs - this.startTimeNs))) {
            Agent.LOG.log(Level.FINEST, "tx response time set: {0}", new Object[]{this.responseTimeNs.get()});
            return true;
        }
        return false;
    }

    public boolean markTimeToFirstByte(long endTimeNs) {
        return this.timeToLastByteNs.get() == 0L && this.timeToFirstByteNs.compareAndSet(0L, Math.max(0L, endTimeNs - this.startTimeNs));
    }

    public void markTransactionAsDone() {
        this.markResponseTime(this.transactionEndTimeNs);
    }

    public void markTransactionActivityAsDone(long newEndTimeNs, long durationNs) {
        if (newEndTimeNs > this.transactionEndTimeNs) {
            this.transactionEndTimeNs = newEndTimeNs;
        }
        this.totalTimeNs += durationNs;
    }

    public long getTimeToFirstByteInNanos() {
        return this.timeToFirstByteNs.get();
    }

    public long getTimetoLastByteInNanos() {
        return this.timeToLastByteNs.get();
    }

    public long getResponseTimeInNanos() {
        return this.responseTimeNs.get();
    }

    public long getRunningDurationInNanos() {
        return this.responseTimeNs.get() > 0L ? this.responseTimeNs.get() : Math.max(0L, System.nanoTime() - this.startTimeNs);
    }

    public long getTotalSumTimeInNanos() {
        return this.totalTimeNs;
    }

    public long getStartTimeInNanos() {
        return this.startTimeNs;
    }

    public long getEndTimeInNanos() {
        return this.transactionEndTimeNs;
    }

    public long getTransactionDurationInNanos() {
        return Math.max(0L, this.transactionEndTimeNs - this.startTimeNs);
    }

    public long getStartTimeInMilliseconds() {
        return TimeUnit.MILLISECONDS.convert(this.startTimeNs, TimeUnit.NANOSECONDS);
    }

    public long getResponseTimeInMilliseconds() {
        return TimeUnit.MILLISECONDS.convert(this.getResponseTimeInNanos(), TimeUnit.NANOSECONDS);
    }

    public long getTotalTimeInMilliseconds() {
        return TimeUnit.MILLISECONDS.convert(this.totalTimeNs, TimeUnit.NANOSECONDS);
    }

    public long getTimeToFirstByteInMilliseconds() {
        return TimeUnit.MILLISECONDS.convert(this.timeToFirstByteNs.get(), TimeUnit.NANOSECONDS);
    }

    public long getTimeToLastByteInMilliseconds() {
        return TimeUnit.MILLISECONDS.convert(this.timeToLastByteNs.get(), TimeUnit.NANOSECONDS);
    }

    public long getEndTimeInMilliseconds() {
        return TimeUnit.MILLISECONDS.convert(this.transactionEndTimeNs, TimeUnit.NANOSECONDS);
    }

    public long getTransactionDurationInMilliseconds() {
        return TimeUnit.MILLISECONDS.convert(Math.max(0L, this.transactionEndTimeNs - this.startTimeNs), TimeUnit.NANOSECONDS);
    }
}

