/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.reinstrument;

import com.newrelic.agent.Agent;
import com.newrelic.agent.deps.com.google.common.collect.Sets;
import com.newrelic.agent.service.ServiceFactory;
import java.lang.instrument.UnmodifiableClassException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class PeriodicRetransformer
implements Runnable {
    private static final int FREQUENCY_IN_SECONDS = 10;
    private final AtomicReference<ConcurrentLinkedQueue<Class<?>>> classesToRetransform = new AtomicReference(new ConcurrentLinkedQueue());
    private final AtomicBoolean scheduled = new AtomicBoolean(false);
    public static final PeriodicRetransformer INSTANCE = new PeriodicRetransformer();

    private PeriodicRetransformer() {
    }

    @Override
    public void run() {
        ConcurrentLinkedQueue classList = this.classesToRetransform.getAndSet(new ConcurrentLinkedQueue());
        if (classList.isEmpty()) {
            return;
        }
        HashSet classSet = Sets.newHashSet(classList);
        try {
            ServiceFactory.getAgent().getInstrumentation().retransformClasses(classSet.toArray(new Class[0]));
        }
        catch (UnmodifiableClassException e) {
            Agent.LOG.fine(MessageFormat.format("Unable to retransform class: {0}", e.getMessage()));
        }
    }

    public void queueRetransform(Class<?> classToRetransform) {
        this.classesToRetransform.get().add(classToRetransform);
        if (!this.scheduled.get() && !this.scheduled.getAndSet(true)) {
            ServiceFactory.getSamplerService().addSampler(this, 10L, TimeUnit.SECONDS);
        }
    }
}

