/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.profile;

import com.newrelic.agent.profile.AbstractController;
import com.newrelic.agent.profile.ProfilingTask;
import java.util.concurrent.atomic.AtomicLong;

public class XrayClockTimeController
extends AbstractController {
    private long startTimeInNanos;
    private final AtomicLong runTime = new AtomicLong();

    public XrayClockTimeController(ProfilingTask profilingTask) {
        super(profilingTask);
    }

    @Override
    public void run() {
        long startTime = System.nanoTime();
        super.run();
        this.runTime.addAndGet(System.nanoTime() - startTime);
    }

    @Override
    protected int doCalculateSamplePeriodInMillis() {
        long runTimeInNanos = this.getAndResetRunTimeInNanos();
        long endTimeInNanos = this.getTimeInNanos();
        int samplePeriod = this.getSamplePeriodInMillis();
        if (this.startTimeInNanos > 0L) {
            long timeInNanos = endTimeInNanos - this.startTimeInNanos;
            samplePeriod = this.calculateSamplePeriodInMillis(timeInNanos, runTimeInNanos);
        }
        this.startTimeInNanos = endTimeInNanos;
        return samplePeriod;
    }

    private int calculateSamplePeriodInMillis(long timeInNanos, long runTimeInNanos) {
        if (runTimeInNanos == 0L || timeInNanos == 0L) {
            return this.getSamplePeriodInMillis();
        }
        float runUtilization = (float)runTimeInNanos / (float)(timeInNanos * (long)this.getProcessorCount());
        return (int)(runUtilization * (float)this.getSamplePeriodInMillis() / TARGET_UTILIZATION);
    }

    protected long getTimeInNanos() {
        return System.nanoTime();
    }

    protected long getAndResetRunTimeInNanos() {
        return this.runTime.getAndSet(0L);
    }
}

