/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.dispatchers;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.config.TransactionTracerConfig;
import com.newrelic.agent.dispatchers.DefaultDispatcher;
import com.newrelic.agent.stats.ApdexStats;
import com.newrelic.agent.stats.TransactionStats;
import com.newrelic.agent.tracers.metricname.MetricNameFormat;
import com.newrelic.agent.transaction.OtherTransactionNamer;
import com.newrelic.agent.transaction.TransactionNamer;
import com.newrelic.api.agent.Request;
import com.newrelic.api.agent.Response;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class OtherDispatcher
extends DefaultDispatcher {
    private final MetricNameFormat uri;

    public OtherDispatcher(Transaction transaction, MetricNameFormat uri) {
        super(transaction);
        this.uri = uri;
    }

    @Override
    public void setTransactionName() {
        TransactionNamer tn = OtherTransactionNamer.create(this.getTransaction(), this.getUri());
        tn.setTransactionName();
    }

    @Override
    public String getUri() {
        return this.uri.getMetricName();
    }

    @Override
    public TransactionTracerConfig getTransactionTracerConfig() {
        return this.getTransaction().getAgentConfig().getBackgroundTransactionTracerConfig();
    }

    @Override
    public void transactionFinished(String transactionName, TransactionStats stats) {
        stats.getUnscopedStats().getResponseTimeStats(transactionName).recordResponseTime(this.getTransaction().getTransactionTimer().getResponseTimeInNanos(), 0L, TimeUnit.NANOSECONDS);
        if (this.hasTransactionName(transactionName, "OtherTransaction")) {
            String totalTimeMetric = this.getTransName(transactionName, "OtherTransaction", "TotalTime");
            stats.getUnscopedStats().getResponseTimeStats(totalTimeMetric).recordResponseTime(this.getTransaction().getTransactionTimer().getTotalSumTimeInNanos(), 0L, TimeUnit.NANOSECONDS);
        }
        stats.getUnscopedStats().getResponseTimeStats("OtherTransaction/all").recordResponseTime(this.getTransaction().getTransactionTimer().getResponseTimeInNanos(), this.getTransaction().getTransactionTimer().getResponseTimeInNanos(), TimeUnit.NANOSECONDS);
        stats.getUnscopedStats().getResponseTimeStats("OtherTransactionTotalTime").recordResponseTime(this.getTransaction().getTransactionTimer().getTotalSumTimeInNanos(), this.getTransaction().getTransactionTimer().getTotalSumTimeInNanos(), TimeUnit.NANOSECONDS);
        this.recordApdexMetrics(transactionName, stats);
        Object cpuTime = this.getTransaction().getIntrinsicAttributes().get("cpuTime");
        if (cpuTime != null && cpuTime instanceof Long) {
            long val = (Long)cpuTime;
            String cpuMetricName = "CPU/" + transactionName;
            stats.getUnscopedStats().getResponseTimeStats(cpuMetricName).recordResponseTimeInNanos(val);
            stats.getUnscopedStats().getResponseTimeStats("CPU/OTherTransaction").recordResponseTimeInNanos(val);
        }
    }

    private void recordApdexMetrics(String transactionName, TransactionStats stats) {
        if (transactionName == null || transactionName.length() == 0) {
            return;
        }
        if (!this.getTransaction().getAgentConfig().isApdexTSet(transactionName)) {
            return;
        }
        if (this.isIgnoreApdex()) {
            Agent.LOG.log(Level.FINE, "Ignoring transaction for apdex {0}", new Object[]{transactionName});
            return;
        }
        String apdexMetricName = this.getApdexMetricName(transactionName, "OtherTransaction", "ApdexOther/Transaction");
        if (apdexMetricName == null || apdexMetricName.length() == 0) {
            return;
        }
        long apdexT = this.getTransaction().getAgentConfig().getApdexTInMillis(transactionName);
        ApdexStats apdexStats = stats.getUnscopedStats().getApdexStats(apdexMetricName);
        ApdexStats overallApdexStats = stats.getUnscopedStats().getApdexStats("ApdexOther");
        if (this.isApdexFrustrating()) {
            apdexStats.recordApdexFrustrated();
            overallApdexStats.recordApdexFrustrated();
        } else {
            long responseTimeInMillis = this.getTransaction().getTransactionTimer().getResponseTimeInMilliseconds();
            apdexStats.recordApdexResponseTime(responseTimeInMillis, apdexT);
            overallApdexStats.recordApdexResponseTime(responseTimeInMillis, apdexT);
        }
    }

    public boolean isApdexFrustrating() {
        return this.getTransaction().isErrorReportableAndNotIgnored() && this.getTransaction().isErrorNotExpected();
    }

    @Override
    public boolean isWebTransaction() {
        return false;
    }

    @Override
    public String getCookieValue(String name) {
        return null;
    }

    @Override
    public String getHeader(String name) {
        return null;
    }

    @Override
    public Request getRequest() {
        return null;
    }

    @Override
    public void setRequest(Request request) {
    }

    @Override
    public Response getResponse() {
        return null;
    }

    @Override
    public void setResponse(Response response) {
    }

    @Override
    public void transactionActivityWithResponseFinished() {
    }
}

