/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.TransactionActivity;
import com.newrelic.agent.TransactionState;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.DefaultSqlTracer;
import com.newrelic.agent.tracers.DefaultTracer;
import com.newrelic.agent.tracers.OtherRootSqlTracer;
import com.newrelic.agent.tracers.OtherRootTracer;
import com.newrelic.agent.tracers.SkipTracer;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.TracerFactory;
import com.newrelic.agent.tracers.TracerFlags;
import com.newrelic.agent.tracers.metricname.MetricNameFormat;
import com.newrelic.agent.tracers.metricname.MetricNameFormats;
import java.util.logging.Level;

public class TransactionStateImpl
implements TransactionState {
    @Override
    public Tracer getTracer(Transaction tx, TracerFactory tracerFactory, ClassMethodSignature sig, Object obj, Object ... args) {
        TransactionActivity activity = tx.getTransactionActivity();
        if (tx.isIgnore() || activity.isTracerStartLocked()) {
            return null;
        }
        Tracer tracer = tracerFactory.getTracer(tx, sig, obj, args);
        return this.tracerStarted(tx, sig, tracer);
    }

    @Override
    public Tracer getTracer(Transaction tx, String tracerFactoryName, ClassMethodSignature sig, Object obj, Object ... args) {
        TracerFactory tracerFactory = ServiceFactory.getTracerService().getTracerFactory(tracerFactoryName);
        return this.getTracer(tx, tracerFactory, sig, obj, args);
    }

    @Override
    public Tracer getTracer(Transaction tx, Object invocationTarget, ClassMethodSignature sig, String metricName, int flags) {
        TransactionActivity activity = tx.getTransactionActivity();
        if (tx.isIgnore() || activity.isTracerStartLocked()) {
            return null;
        }
        MetricNameFormat mnf = MetricNameFormats.getFormatter(invocationTarget, sig, metricName, flags);
        DefaultTracer tracer = TracerFlags.isDispatcher((int)flags) ? new OtherRootTracer(tx, sig, invocationTarget, mnf) : new DefaultTracer(tx, sig, invocationTarget, mnf, flags);
        return this.tracerStarted(tx, sig, tracer);
    }

    @Override
    public Tracer getSqlTracer(Transaction tx, Object invocationTarget, ClassMethodSignature sig, String metricName, int flags) {
        TransactionActivity activity = tx.getTransactionActivity();
        if (tx.isIgnore() || activity.isTracerStartLocked()) {
            return null;
        }
        MetricNameFormat mnf = MetricNameFormats.getFormatter(invocationTarget, sig, metricName, flags);
        DefaultSqlTracer tracer = TracerFlags.isDispatcher((int)flags) ? new OtherRootSqlTracer(tx, sig, invocationTarget, mnf) : new DefaultSqlTracer(tx, sig, invocationTarget, mnf, flags);
        return this.tracerStarted(tx, sig, tracer);
    }

    private Tracer tracerStarted(Transaction tx, ClassMethodSignature sig, Tracer tracer) {
        if (tracer == null || tracer instanceof SkipTracer) {
            return tracer;
        }
        tracer = tx.getTransactionActivity().tracerStarted(tracer);
        if (tracer != null && Agent.LOG.isLoggable(Level.FINER)) {
            if (tracer == tx.getRootTracer()) {
                Agent.LOG.log(Level.FINER, "Transaction started {0}", new Object[]{tx});
            }
            Agent.LOG.log(Level.FINER, "Tracer ({3}) Started: {0}.{1}{2}", new Object[]{sig.getClassName(), sig.getMethodName(), sig.getMethodDesc(), tracer});
        }
        return tracer;
    }

    @Override
    public Tracer getRootTracer() {
        return null;
    }

    @Override
    public void resume() {
    }

    @Override
    public void suspend() {
    }

    @Override
    public void complete() {
    }

    @Override
    public boolean finish(Transaction tx, Tracer tracer) {
        return true;
    }

    @Override
    public void suspendRootTracer() {
    }
}

