/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.WeakRefTransaction;
import com.newrelic.agent.bridge.TracedActivity;
import com.newrelic.agent.bridge.TracedMethod;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.api.agent.ExternalParameters;
import com.newrelic.api.agent.OutboundHeaders;
import com.newrelic.api.agent.Transaction;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicBoolean;

public class Segment
implements TracedActivity {
    private final WeakReference<Tracer> underlyingTracer;
    private final WeakReference<Tracer> parent;
    private final WeakRefTransaction weakRefTransaction;
    private final long parentInitialExclusiveDuration;
    private final AtomicBoolean isFinished = new AtomicBoolean(false);
    private final String initiatingThread = Thread.currentThread().getName();
    public static final String UNNAMED_SEGMENT = "Unnamed Segment";
    public static final String START_THREAD = "start_thread";
    public static final String END_THREAD = "end_thread";

    public Segment(Tracer parent, Tracer tracer) {
        this.parent = new WeakReference<Tracer>(parent);
        this.underlyingTracer = new WeakReference<Tracer>(tracer);
        this.weakRefTransaction = new WeakRefTransaction(parent.getTransactionActivity().getTransaction());
        this.parentInitialExclusiveDuration = parent.getExclusiveDuration();
    }

    public Transaction getTransaction() {
        return this.weakRefTransaction;
    }

    public void ignore() {
        this.ignoreIfUnfinished();
    }

    public void reportAsExternal(ExternalParameters externalParameters) {
        Tracer tracer = (Tracer)this.underlyingTracer.get();
        if (tracer != null) {
            tracer.reportAsExternal(externalParameters);
        }
    }

    public void setMetricName(String ... metricNameParts) {
        Tracer tracer = (Tracer)this.underlyingTracer.get();
        if (tracer != null) {
            tracer.setMetricName(metricNameParts);
        }
    }

    public void addOutboundRequestHeaders(OutboundHeaders outboundHeaders) {
        Tracer tracer = (Tracer)this.underlyingTracer.get();
        if (tracer != null) {
            tracer.addOutboundRequestHeaders(outboundHeaders);
        }
    }

    public TracedMethod getTracedMethod() {
        return (TracedMethod)this.underlyingTracer.get();
    }

    public void setAsyncThreadName(String threadName) {
    }

    public Tracer getParent() {
        return (Tracer)this.parent.get();
    }

    public Tracer getTracer() {
        return (Tracer)this.underlyingTracer.get();
    }

    public long getParentInitialExclusiveDuration() {
        return this.parentInitialExclusiveDuration;
    }

    public void ignoreIfUnfinished() {
        Tracer tracer;
        if (!this.isFinished.getAndSet(true) && (tracer = (Tracer)this.parent.get()) != null) {
            tracer.getTransactionActivity().getTransaction().ignoreSegmentIfUnfinished(this);
        }
    }

    public void finish() {
        this.finish(null);
    }

    public void end() {
        this.finish(null);
    }

    public void finish(Throwable t) {
        Tracer tracer;
        if (!this.isFinished.getAndSet(true) && (tracer = (Tracer)this.parent.get()) != null) {
            tracer.getTransactionActivity().getTransaction().finishSegment(this, t);
        }
    }

    public String getInitiatingThread() {
        return this.initiatingThread;
    }

    public void setTruncated() {
        Tracer tracer = (Tracer)this.underlyingTracer.get();
        if (tracer != null) {
            tracer.setMetricNameFormatInfo(tracer.getMetricName(), "Truncated/" + tracer.getMetricName(), tracer.getTransactionSegmentUri());
        }
    }
}

