/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.trace;

import com.newrelic.agent.Agent;
import com.newrelic.agent.TransactionData;
import com.newrelic.agent.attributes.AttributesUtils;
import com.newrelic.agent.bridge.datastore.ConnectionFactory;
import com.newrelic.agent.bridge.datastore.DatabaseVendor;
import com.newrelic.agent.config.TransactionTracerConfig;
import com.newrelic.agent.database.DatabaseService;
import com.newrelic.agent.database.ExplainPlanExecutor;
import com.newrelic.agent.database.SqlObfuscator;
import com.newrelic.agent.deps.com.google.common.collect.Lists;
import com.newrelic.agent.deps.com.google.common.collect.Maps;
import com.newrelic.agent.deps.org.json.simple.JSONArray;
import com.newrelic.agent.deps.org.json.simple.JSONStreamAware;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.trace.TransactionSegment;
import com.newrelic.agent.tracers.SqlTracer;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.transport.DataSenderWriter;
import java.io.IOException;
import java.io.Writer;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class TransactionTrace
implements Comparable<TransactionTrace>,
JSONStreamAware {
    private static final String HAS_ASYNCH_CHILD_ATT = "async_wait";
    private final TransactionSegment rootSegment;
    private final List<TransactionSegment> sqlSegments;
    private final Map<ConnectionFactory, List<ExplainPlanExecutor>> sqlTracers;
    private final long duration;
    private final long startTime;
    private String requestUri;
    private final String rootMetricName;
    private final Map<String, Object> userAttributes;
    private final Map<String, Object> agentAttributes;
    private final Map<String, Object> intrinsicAttributes;
    private final long rootTracerStartTime;
    private Map<Tracer, Collection<Tracer>> children;
    private final String guid;
    private final Map<String, Map<String, String>> prefixedAttributes;
    private Long xraySessionId;
    private String syntheticsResourceId;
    private final String applicationName;

    private TransactionTrace(TransactionData transactionData, SqlObfuscator sqlObfuscator) {
        this.applicationName = transactionData.getApplicationName();
        this.children = TransactionTrace.buildChildren(transactionData.getTracers());
        this.sqlTracers = new HashMap<ConnectionFactory, List<ExplainPlanExecutor>>();
        Tracer tracer = transactionData.getRootTracer();
        this.userAttributes = Maps.newHashMap();
        this.agentAttributes = Maps.newHashMap();
        if (ServiceFactory.getAttributesService().isAttributesEnabledForTraces(this.applicationName)) {
            if (transactionData.getAgentAttributes() != null) {
                this.agentAttributes.putAll(transactionData.getAgentAttributes());
            }
            if (transactionData.getUserAttributes() != null) {
                this.userAttributes.putAll(transactionData.getUserAttributes());
            }
        }
        this.prefixedAttributes = transactionData.getPrefixedAttributes();
        this.intrinsicAttributes = TransactionTrace.getIntrinsics(transactionData);
        this.startTime = transactionData.getWallClockStartTimeMs();
        this.rootTracerStartTime = tracer.getStartTimeInMilliseconds();
        this.sqlSegments = new LinkedList<TransactionSegment>();
        this.requestUri = transactionData.getRequestUri("transaction_tracer");
        if (this.requestUri == null || this.requestUri.length() == 0) {
            this.requestUri = "/ROOT";
        }
        this.rootMetricName = transactionData.getBlameOrRootMetricName();
        this.guid = transactionData.getGuid();
        this.rootSegment = new TransactionSegment(transactionData.getTransactionTracerConfig(), sqlObfuscator, this.rootTracerStartTime, tracer, this.createTransactionSegment(transactionData.getTransactionTracerConfig(), sqlObfuscator, tracer, null));
        this.rootSegment.setMetricName("ROOT");
        long txDurMs = Math.max(0L, transactionData.getTransactionTime().getEndTimeInMilliseconds() - this.rootTracerStartTime);
        this.rootSegment.resetExitTimeStampInMs(txDurMs);
        this.duration = transactionData.getTransactionTime().getResponseTimeInMilliseconds();
        this.children.clear();
        this.children = null;
        this.xraySessionId = null;
        this.syntheticsResourceId = null;
    }

    private static Map<String, Object> getIntrinsics(TransactionData transactionData) {
        Long cpuTime;
        Long gcTime;
        HashMap<String, Object> intrinsicAttributes = Maps.newHashMap();
        if (transactionData.getIntrinsicAttributes() != null) {
            intrinsicAttributes.putAll(transactionData.getIntrinsicAttributes());
        }
        intrinsicAttributes.put("totalTime", Float.valueOf((float)transactionData.getTransactionTime().getTotalSumTimeInNanos() / 1.0E9f));
        if (transactionData.getTransactionTime().getTimeToFirstByteInNanos() > 0L) {
            intrinsicAttributes.put("timeToFirstByte", Float.valueOf((float)transactionData.getTransactionTime().getTimeToFirstByteInNanos() / 1.0E9f));
        }
        if (transactionData.getTransactionTime().getTimetoLastByteInNanos() > 0L) {
            intrinsicAttributes.put("timeToLastByte", Float.valueOf((float)transactionData.getTransactionTime().getTimetoLastByteInNanos() / 1.0E9f));
        }
        if ((gcTime = (Long)intrinsicAttributes.remove("gc_time")) != null) {
            float gcTimeInSecs = (float)gcTime.longValue() / 1.0E9f;
            intrinsicAttributes.put("gc_time", Float.valueOf(gcTimeInSecs));
        }
        if ((cpuTime = (Long)intrinsicAttributes.remove("cpuTime")) != null) {
            float cpuTimeInSecs = (float)cpuTime.longValue() / 1.0E9f;
            intrinsicAttributes.put("cpuTime", Float.valueOf(cpuTimeInSecs));
        }
        return intrinsicAttributes;
    }

    public static Map<Tracer, Collection<Tracer>> buildChildren(Collection<Tracer> tracers) {
        if (tracers == null || tracers.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Tracer, Collection<Tracer>> children = new HashMap<Tracer, Collection<Tracer>>();
        for (Tracer tracer : tracers) {
            ArrayList<Tracer> kids;
            Tracer parentTracer;
            for (parentTracer = tracer.getParentTracer(); null != parentTracer && !parentTracer.isTransactionSegment(); parentTracer = parentTracer.getParentTracer()) {
            }
            if (tracer.getAttribute("async_context") != null && parentTracer != null) {
                parentTracer.setAttribute(HAS_ASYNCH_CHILD_ATT, Boolean.TRUE);
            }
            if ((kids = (ArrayList<Tracer>)children.get(parentTracer)) == null) {
                kids = Lists.newArrayListWithExpectedSize(parentTracer == null ? 1 : Math.max(1, parentTracer.getChildCount()));
                children.put(parentTracer, kids);
            }
            kids.add(tracer);
        }
        return children;
    }

    public long getStartTime() {
        return this.startTime;
    }

    private static SqlObfuscator getSqlObfuscator(String appName) {
        SqlObfuscator sqlObfuscator = ServiceFactory.getDatabaseService().getSqlObfuscator(appName);
        return SqlObfuscator.getCachingSqlObfuscator(sqlObfuscator);
    }

    public static TransactionTrace getTransactionTrace(TransactionData td) {
        return TransactionTrace.getTransactionTrace(td, TransactionTrace.getSqlObfuscator(td.getApplicationName()));
    }

    static TransactionTrace getTransactionTrace(TransactionData transactionData, SqlObfuscator sqlObfuscator) {
        return new TransactionTrace(transactionData, sqlObfuscator);
    }

    public TransactionSegment getRootSegment() {
        return this.rootSegment;
    }

    private TransactionSegment createTransactionSegment(TransactionTracerConfig ttConfig, SqlObfuscator sqlObfuscator, Tracer tracer, TransactionSegment lastSibling) {
        TransactionSegment segment = tracer.getTransactionSegment(ttConfig, sqlObfuscator, this.rootTracerStartTime, lastSibling);
        this.processSqlTracer(tracer);
        Collection<Tracer> children = this.children.get(tracer);
        if (children != null) {
            TransactionSegment lastKid = null;
            for (Tracer child : children) {
                TransactionSegment childSegment;
                if (child.getTransactionSegmentName() == null || (childSegment = this.createTransactionSegment(ttConfig, sqlObfuscator, child, lastKid)) == lastKid) continue;
                segment.addChild(childSegment);
                lastKid = childSegment;
            }
        }
        return segment;
    }

    public Map<ConnectionFactory, List<ExplainPlanExecutor>> getExplainPlanExecutors() {
        return Collections.unmodifiableMap(this.sqlTracers);
    }

    private void processSqlTracer(Tracer tracer) {
        if (tracer instanceof SqlTracer) {
            SqlTracer sqlTracer = (SqlTracer)tracer;
            ExplainPlanExecutor explainExecutor = sqlTracer.getExplainPlanExecutor();
            ConnectionFactory connectionFactory = sqlTracer.getConnectionFactory();
            if (!sqlTracer.hasExplainPlan() && explainExecutor != null && connectionFactory != null) {
                List<ExplainPlanExecutor> tracers = this.sqlTracers.get(connectionFactory);
                if (tracers == null) {
                    tracers = new LinkedList<ExplainPlanExecutor>();
                    this.sqlTracers.put(connectionFactory, tracers);
                }
                tracers.add(explainExecutor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runExplainPlans() {
        if (!this.sqlTracers.isEmpty()) {
            DatabaseService dbService = ServiceFactory.getDatabaseService();
            for (Map.Entry<ConnectionFactory, List<ExplainPlanExecutor>> entry : this.sqlTracers.entrySet()) {
                Agent.LOG.finer(MessageFormat.format("Running {0} explain plan(s)", entry.getValue().size()));
                Connection connection = null;
                try {
                    connection = entry.getKey().getConnection();
                    DatabaseVendor vendor = entry.getKey().getDatabaseVendor();
                    for (ExplainPlanExecutor explainExecutor : entry.getValue()) {
                        if (explainExecutor == null) continue;
                        explainExecutor.runExplainPlan(dbService, connection, vendor);
                    }
                }
                catch (Throwable t) {
                    String msg = MessageFormat.format("An error occurred executing an explain plan: {0}", t.toString());
                    if (Agent.LOG.isLoggable(Level.FINER)) {
                        Agent.LOG.log(Level.FINER, msg, t);
                        continue;
                    }
                    Agent.LOG.fine(msg);
                }
                finally {
                    if (connection == null) continue;
                    try {
                        connection.close();
                    }
                    catch (Exception e) {
                        Agent.LOG.log(Level.FINER, "Unable to close connection", e);
                    }
                }
            }
            this.sqlTracers.clear();
        }
    }

    private Map<String, Object> getAgentAtts() {
        HashMap<String, Object> atts = Maps.newHashMap();
        atts.putAll(this.agentAttributes);
        if (this.prefixedAttributes != null && !this.prefixedAttributes.isEmpty()) {
            atts.putAll(AttributesUtils.appendAttributePrefixes(this.prefixedAttributes));
        }
        return atts;
    }

    private void filterAndAddIfNotEmpty(String key, Map<String, Object> wheretoAdd, Map<String, Object> toAdd) {
        Map<String, ? extends Object> output = ServiceFactory.getAttributesService().filterTraceAttributes(this.applicationName, toAdd);
        if (output != null && !output.isEmpty()) {
            wheretoAdd.put(key, output);
        }
    }

    private Map<String, Object> getAttributes() {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        if (ServiceFactory.getAttributesService().isAttributesEnabledForTraces(this.applicationName)) {
            this.filterAndAddIfNotEmpty("agentAttributes", attributes, this.getAgentAtts());
            if (!ServiceFactory.getConfigService().getDefaultAgentConfig().isHighSecurity()) {
                this.filterAndAddIfNotEmpty("userAttributes", attributes, this.userAttributes);
            }
        }
        if (this.intrinsicAttributes != null && !this.intrinsicAttributes.isEmpty()) {
            attributes.put("intrinsics", this.intrinsicAttributes);
        }
        return attributes;
    }

    @Override
    public void writeJSONString(Writer writer) throws IOException {
        this.runExplainPlans();
        boolean forcePersist = false;
        List<Object> data = Arrays.asList(this.startTime, Collections.EMPTY_MAP, Collections.EMPTY_MAP, this.rootSegment, this.getAttributes());
        if (null == this.xraySessionId && null == this.syntheticsResourceId) {
            JSONArray.writeJSONString(Arrays.asList(this.startTime, this.duration, this.rootMetricName, this.requestUri, this.getData(writer, data), this.guid, null, false), writer);
        } else if (null == this.syntheticsResourceId) {
            JSONArray.writeJSONString(Arrays.asList(this.startTime, this.duration, this.rootMetricName, this.requestUri, this.getData(writer, data), this.guid, null, true, this.xraySessionId), writer);
        } else {
            JSONArray.writeJSONString(Arrays.asList(this.startTime, this.duration, this.rootMetricName, this.requestUri, this.getData(writer, data), this.guid, null, true, this.xraySessionId, this.syntheticsResourceId), writer);
        }
    }

    private Object getData(Writer writer, List<Object> data) {
        return DataSenderWriter.getJsonifiedOptionallyCompressedEncodedString(data, writer, 1);
    }

    protected List<TransactionSegment> getSQLSegments() {
        return this.sqlSegments;
    }

    public String toString() {
        return MessageFormat.format("{0} {1} ms", this.requestUri, this.duration);
    }

    @Override
    public int compareTo(TransactionTrace o) {
        return (int)(this.duration - o.duration);
    }

    public long getDuration() {
        return this.duration;
    }

    public String getRequestUri() {
        return this.requestUri;
    }

    public void setXraySessionId(Long xraySessionId) {
        this.xraySessionId = xraySessionId;
    }

    public Long getXraySessionId() {
        return this.xraySessionId;
    }

    public void setSyntheticsResourceId(String syntheticsResourceId) {
        this.syntheticsResourceId = syntheticsResourceId;
    }

    public String getSyntheticsResourceId() {
        return this.syntheticsResourceId;
    }

    public String getRootMetricName() {
        return this.rootMetricName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public Map<String, Object> getIntrinsicsShallowCopy() {
        return Maps.newHashMap(this.intrinsicAttributes);
    }
}

