/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.stats;

import com.newrelic.agent.stats.AbstractStats;
import com.newrelic.agent.stats.Stats;
import com.newrelic.agent.stats.StatsBase;

public class StatsImpl
extends AbstractStats
implements Stats {
    private float total;
    private float minValue;
    private float maxValue;
    private double sumOfSquares;

    protected StatsImpl() {
    }

    public StatsImpl(int count, float total, float minValue, float maxValue, double sumOfSquares) {
        super(count);
        this.total = total;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.sumOfSquares = sumOfSquares;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        StatsImpl newStats = new StatsImpl();
        newStats.count = this.count;
        newStats.total = this.total;
        newStats.minValue = this.minValue;
        newStats.maxValue = this.maxValue;
        newStats.sumOfSquares = this.sumOfSquares;
        return newStats;
    }

    public String toString() {
        return super.toString() + " [tot=" + this.total + ", min=" + this.minValue + ", maxV=" + this.maxValue + "]";
    }

    @Override
    public void recordDataPoint(float value) {
        if (Float.isNaN(value) || Float.isInfinite(value)) {
            throw new IllegalArgumentException("Data points must be numbers");
        }
        double sos = this.sumOfSquares + (double)(value * value);
        if (sos < this.sumOfSquares) {
            throw new IllegalArgumentException("Data value " + value + " caused sum of squares to roll over");
        }
        this.minValue = this.count > 0 ? Math.min(value, this.minValue) : value;
        ++this.count;
        this.total += value;
        this.maxValue = Math.max(value, this.maxValue);
        this.sumOfSquares = sos;
    }

    @Override
    public boolean hasData() {
        return this.count > 0 || this.total > 0.0f;
    }

    @Override
    public void reset() {
        this.count = 0;
        this.maxValue = 0.0f;
        this.minValue = 0.0f;
        this.total = 0.0f;
        this.sumOfSquares = 0.0;
    }

    @Override
    public float getTotal() {
        return this.total;
    }

    @Override
    public float getTotalExclusiveTime() {
        return this.total;
    }

    @Override
    public float getMinCallTime() {
        return this.minValue;
    }

    @Override
    public float getMaxCallTime() {
        return this.maxValue;
    }

    @Override
    public double getSumOfSquares() {
        return this.sumOfSquares;
    }

    @Override
    public void merge(StatsBase statsObj) {
        if (statsObj instanceof StatsImpl) {
            StatsImpl stats = (StatsImpl)statsObj;
            if (stats.count > 0) {
                this.minValue = this.count > 0 ? Math.min(this.minValue, stats.minValue) : stats.minValue;
            }
            this.count += stats.count;
            this.total += stats.total;
            this.maxValue = Math.max(this.maxValue, stats.maxValue);
            this.sumOfSquares += stats.sumOfSquares;
        }
    }
}

