/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.profile.method;

import com.newrelic.agent.deps.com.google.common.collect.ImmutableMap;
import com.newrelic.agent.deps.com.google.common.collect.Maps;
import com.newrelic.agent.profile.method.MethodInfo;
import com.newrelic.agent.profile.method.MethodInfoUtil;
import com.newrelic.agent.service.ServiceFactory;
import java.util.HashMap;
import java.util.concurrent.ConcurrentMap;

public class MethodInfoFactory {
    private final ConcurrentMap<MethodKey, MethodInfo> methods = Maps.newConcurrentMap();
    private final ImmutableMap<String, Class<?>> classMap;

    public MethodInfoFactory() {
        this(ServiceFactory.getAgent().getInstrumentation().getAllLoadedClasses());
    }

    public MethodInfoFactory(Class[] allLoadedClasses) {
        HashMap<String, Class> classMap = Maps.newHashMapWithExpectedSize(allLoadedClasses.length);
        for (Class clazz : allLoadedClasses) {
            classMap.put(clazz.getName(), clazz);
        }
        this.classMap = ImmutableMap.copyOf(classMap);
    }

    public MethodInfo getMethodInfo(String className, String methodName, int lineNumber) {
        MethodKey key = new MethodKey(className, methodName, lineNumber);
        MethodInfo methodInfo = (MethodInfo)this.methods.get(key);
        if (null == methodInfo) {
            Class<?> declaringClass = this.classMap.get(className);
            if (declaringClass == null) {
                return null;
            }
            methodInfo = MethodInfoUtil.createMethodInfo(declaringClass, methodName, lineNumber);
            MethodInfo previous = this.methods.putIfAbsent(key, methodInfo);
            if (previous != null) {
                return previous;
            }
        }
        return methodInfo;
    }

    private static final class MethodKey {
        final String className;
        final String methodName;
        final int lineNumber;

        public MethodKey(String className, String methodName, int lineNumber) {
            this.className = className;
            this.methodName = methodName;
            this.lineNumber = lineNumber;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
            result = 31 * result + this.lineNumber;
            result = 31 * result + (this.methodName == null ? 0 : this.methodName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MethodKey other = (MethodKey)obj;
            if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
                return false;
            }
            if (this.lineNumber != other.lineNumber) {
                return false;
            }
            return !(this.methodName == null ? other.methodName != null : !this.methodName.equals(other.methodName));
        }
    }
}

