/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.profile;

import com.newrelic.agent.Agent;
import com.newrelic.agent.profile.IProfile;
import com.newrelic.agent.profile.RunnableThreadRules;
import com.newrelic.agent.profile.ThreadType;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.util.StackTraces;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ProfileSampler {
    public static final int MAX_STACK_DEPTH = 300;
    private static final ThreadInfo[] EMPTY_THREAD_INFO_ARRAY = new ThreadInfo[0];

    public void sampleStackTraces(List<IProfile> profiles) {
        if (profiles.isEmpty()) {
            return;
        }
        for (IProfile profile : profiles) {
            profile.beforeSampling();
            this.addThreadInfos(profile, this.getAllThreadInfos());
        }
    }

    private void addThreadInfos(IProfile profiler, ThreadInfo[] threadInfos) {
        if (threadInfos.length == 0) {
            return;
        }
        Set<Long> agentThreadIds = ServiceFactory.getThreadService().getAgentThreadIds();
        RunnableThreadRules runnableThreadRules = new RunnableThreadRules();
        for (ThreadInfo threadInfo : threadInfos) {
            boolean isRunnable;
            if (threadInfo == null || !(isRunnable = runnableThreadRules.isRunnable(threadInfo)) && profiler.getProfilerParameters().isRunnablesOnly()) continue;
            long threadId = threadInfo.getThreadId();
            ThreadType.BasicThreadType type = agentThreadIds.contains(threadId) ? ThreadType.BasicThreadType.AGENT : (profiler.getProfilerParameters().isProfileAgentThreads() && StackTraces.isInAgentInstrumentation(threadInfo.getStackTrace()) ? ThreadType.BasicThreadType.AGENT_INSTRUMENTATION : ThreadType.BasicThreadType.OTHER);
            profiler.addStackTrace(threadId, isRunnable, type, threadInfo.getStackTrace());
        }
    }

    private ThreadInfo[] getAllThreadInfos() {
        long[] threadIds = this.getAllThreadIds();
        if (threadIds == null || threadIds.length == 0) {
            return EMPTY_THREAD_INFO_ARRAY;
        }
        HashSet<Long> ids = new HashSet<Long>(threadIds.length);
        for (long threadId : threadIds) {
            ids.add(threadId);
        }
        ids.remove(Thread.currentThread().getId());
        threadIds = this.convertToLongArray(ids);
        return this.getThreadInfos(threadIds);
    }

    private long[] convertToLongArray(Set<Long> ids) {
        long[] arr = new long[ids.size()];
        int i = 0;
        for (Long id : ids) {
            arr[i++] = id;
        }
        return arr;
    }

    private ThreadInfo[] getThreadInfos(long[] threadIds) {
        try {
            ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
            if (threadIds.length > 0) {
                return threadMXBean.getThreadInfo(threadIds, 300);
            }
        }
        catch (SecurityException e) {
            Agent.LOG.finer(MessageFormat.format("An error occurred getting thread info: {0}", e));
        }
        return EMPTY_THREAD_INFO_ARRAY;
    }

    private long[] getAllThreadIds() {
        try {
            ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
            return threadMXBean.getAllThreadIds();
        }
        catch (SecurityException e) {
            Agent.LOG.finer(MessageFormat.format("An error occurred getting all thread ids: {0}", e));
            return null;
        }
    }
}

