/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.Agent;
import com.newrelic.agent.config.BaseConfig;
import com.newrelic.agent.config.ClassTransformerConfig;
import com.newrelic.agent.config.Config;
import com.newrelic.agent.deps.com.google.common.collect.Sets;
import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.instrumentation.annotationmatchers.AnnotationMatcher;
import com.newrelic.agent.instrumentation.annotationmatchers.ClassNameAnnotationMatcher;
import com.newrelic.agent.instrumentation.annotationmatchers.NoMatchAnnotationMatcher;
import com.newrelic.agent.instrumentation.annotationmatchers.OrAnnotationMatcher;
import com.newrelic.weave.weavepackage.WeavePackageConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

final class ClassTransformerConfigImpl
extends BaseConfig
implements ClassTransformerConfig {
    public static final String ENABLED = "enabled";
    public static final String EXCLUDES = "excludes";
    public static final String INCLUDES = "includes";
    public static final String CLASSLOADER_BLACKLIST = "classloader_blacklist";
    public static final String CLASSLOADER_DELEGATION_EXCLUDES = "classloader_delegation_excludes";
    public static final String CLASSLOADER_EXCLUDES = "classloader_excludes";
    public static final String MAX_PREVALIDATED_CLASSLOADERS = "max_prevalidated_classloaders";
    public static final String PREVALIDATE_WEAVE_PACKAGES = "prevalidate_weave_packages";
    public static final String PREMATCH_WEAVE_METHODS = "prematch_weave_methods";
    public static final String DEFAULT_INSTRUMENTATION = "instrumentation_default";
    public static final String BUILTIN_EXTENSIONS = "builtin_extensions";
    public static final String COMPUTE_FRAMES = "compute_frames";
    public static final String SHUTDOWN_DELAY = "shutdown_delay";
    public static final String GRANT_PACKAGE_ACCESS = "grant_package_access";
    public static final boolean DEFAULT_COMPUTE_FRAMES = true;
    public static final boolean DEFAULT_ENABLED = true;
    public static final boolean DEFAULT_DISABLED = false;
    public static final int DEFAULT_SHUTDOWN_DELAY = -1;
    public static final boolean DEFAULT_GRANT_PACKAGE_ACCESS = false;
    public static final int DEFAULT_MAX_PREVALIDATED_CLASSLOADERS = 10;
    public static final boolean DEFAULT_PREVALIDATE_WEAVE_PACKAGES = true;
    public static final boolean DEFAULT_PREMATCH_WEAVE_METHODS = true;
    private static final String SYSTEM_PROPERTY_ROOT = "newrelic.config.class_transformer.";
    static final String NEW_RELIC_TRACE_TYPE_DESC = "Lcom/newrelic/api/agent/Trace;";
    static final String DEPRECATED_NEW_RELIC_TRACE_TYPE_DESC = "Lcom/newrelic/agent/Trace;";
    private final boolean isEnabled;
    private final boolean custom_tracing;
    private final Set<String> excludes;
    private final Set<String> includes;
    private final Set<String> classloaderBlacklist;
    private final Set<String> classloaderDelegationExcludes;
    private final boolean computeFrames;
    private final boolean isDefaultInstrumentationEnabled;
    private final long shutdownDelayInNanos;
    private final boolean grantPackageAccess;
    private final int maxPreValidatedClassLoaders;
    private final boolean preValidateWeavePackages;
    private final boolean preMatchWeaveMethods;
    private final AnnotationMatcher ignoreTransactionAnnotationMatcher;
    private final AnnotationMatcher ignoreApdexAnnotationMatcher;
    private final AnnotationMatcher traceAnnotationMatcher;
    private final boolean defaultMethodTracingEnabled;
    private final boolean isBuiltinExtensionEnabled;
    private final boolean litemode;
    public static final String JDBC_STATEMENTS_PROPERTY = "jdbc_statements";

    public ClassTransformerConfigImpl(Map<String, Object> props, boolean customTracingEnabled, boolean litemode) {
        super(props, SYSTEM_PROPERTY_ROOT);
        this.custom_tracing = customTracingEnabled;
        this.litemode = litemode;
        this.isEnabled = this.getProperty(ENABLED, true);
        this.isDefaultInstrumentationEnabled = this.getDefaultInstrumentationEnabled();
        this.isBuiltinExtensionEnabled = this.getBuiltinExensionEnabled();
        this.excludes = Collections.unmodifiableSet(new HashSet<String>(this.getUniqueStrings(EXCLUDES)));
        this.includes = Collections.unmodifiableSet(new HashSet<String>(this.getUniqueStrings(INCLUDES)));
        this.classloaderBlacklist = this.initializeClassloaderBlacklist();
        this.classloaderDelegationExcludes = this.initializeClassloaderDelegationExcludes();
        this.computeFrames = this.getProperty(COMPUTE_FRAMES, true);
        this.shutdownDelayInNanos = this.initShutdownDelay();
        this.grantPackageAccess = this.getProperty(GRANT_PACKAGE_ACCESS, false);
        this.maxPreValidatedClassLoaders = this.getProperty(MAX_PREVALIDATED_CLASSLOADERS, 10);
        this.preValidateWeavePackages = this.getProperty(PREVALIDATE_WEAVE_PACKAGES, true);
        this.preMatchWeaveMethods = this.getProperty(PREMATCH_WEAVE_METHODS, true);
        this.defaultMethodTracingEnabled = this.getProperty("default_method_tracing_enabled", true);
        this.traceAnnotationMatcher = customTracingEnabled ? this.initializeTraceAnnotationMatcher(props) : new NoMatchAnnotationMatcher();
        this.ignoreTransactionAnnotationMatcher = new ClassNameAnnotationMatcher("NewRelicIgnoreTransaction", false);
        this.ignoreApdexAnnotationMatcher = new ClassNameAnnotationMatcher("NewRelicIgnoreApdex", false);
    }

    public ClassTransformerConfigImpl(Map<String, Object> props, boolean customTracingEnabled) {
        this(props, customTracingEnabled, false);
    }

    private boolean getBuiltinExensionEnabled() {
        Boolean builtinExtensionEnabled = (Boolean)this.getInstrumentationConfig(BUILTIN_EXTENSIONS).getProperty(ENABLED);
        return this.isDefaultInstrumentationEnabled || builtinExtensionEnabled != null && builtinExtensionEnabled != false;
    }

    private boolean getDefaultInstrumentationEnabled() {
        Boolean defaultInstrumentationEnabled = (Boolean)this.getInstrumentationConfig(DEFAULT_INSTRUMENTATION).getProperty(ENABLED);
        if (this.litemode) {
            return false;
        }
        if (defaultInstrumentationEnabled == null || defaultInstrumentationEnabled.booleanValue()) {
            return true;
        }
        Agent.LOG.info("Instrumentation is disabled by default");
        return false;
    }

    private Set<String> initializeClassloaderBlacklist() {
        HashSet<String> classloadersToExclude = new HashSet<String>(this.getUniqueStrings(CLASSLOADER_BLACKLIST));
        classloadersToExclude.addAll(this.getUniqueStrings(CLASSLOADER_EXCLUDES));
        return Collections.unmodifiableSet(classloadersToExclude);
    }

    private Set<String> initializeClassloaderDelegationExcludes() {
        HashSet<String> classloadersToExclude = new HashSet<String>(this.getUniqueStrings(CLASSLOADER_DELEGATION_EXCLUDES));
        return Collections.unmodifiableSet(classloadersToExclude);
    }

    private AnnotationMatcher initializeTraceAnnotationMatcher(Map<?, ?> props) {
        ArrayList<AnnotationMatcher> matchers = new ArrayList<AnnotationMatcher>();
        matchers.add(new ClassNameAnnotationMatcher(Type.getType(DEPRECATED_NEW_RELIC_TRACE_TYPE_DESC).getDescriptor()));
        matchers.add(new ClassNameAnnotationMatcher(Type.getType(NEW_RELIC_TRACE_TYPE_DESC).getDescriptor()));
        Collection<String> traceAnnotationClassNames = this.getUniqueStrings("trace_annotation_class_name");
        if (traceAnnotationClassNames.isEmpty()) {
            matchers.add(new ClassNameAnnotationMatcher("NewRelicTrace", false));
        } else {
            final HashSet<String> internalizedNames = Sets.newHashSet();
            for (String name : traceAnnotationClassNames) {
                Agent.LOG.fine("Adding " + name + " as a Trace annotation");
                internalizedNames.add(ClassTransformerConfigImpl.internalizeName(name));
            }
            matchers.add(new AnnotationMatcher(){

                @Override
                public boolean matches(String annotationDesc) {
                    return internalizedNames.contains(annotationDesc);
                }
            });
        }
        return OrAnnotationMatcher.getOrMatcher(matchers.toArray(new AnnotationMatcher[0]));
    }

    static String internalizeName(String name) {
        return 'L' + name.trim().replace('.', '/') + ';';
    }

    private long initShutdownDelay() {
        int shutdownDelayInSeconds = this.getIntProperty(SHUTDOWN_DELAY, -1);
        if (shutdownDelayInSeconds > 0) {
            return TimeUnit.NANOSECONDS.convert(shutdownDelayInSeconds, TimeUnit.SECONDS);
        }
        return -1L;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public boolean isCustomTracingEnabled() {
        return this.custom_tracing;
    }

    @Override
    public Set<String> getIncludes() {
        return this.includes;
    }

    @Override
    public Set<String> getClassloaderBlacklist() {
        return this.classloaderBlacklist;
    }

    @Override
    public Set<String> getClassloaderDelegationExcludes() {
        return this.classloaderDelegationExcludes;
    }

    @Override
    public boolean isDefaultInstrumentationEnabled() {
        return this.isDefaultInstrumentationEnabled;
    }

    @Override
    public boolean isBuiltinExtensionEnabled() {
        return this.isBuiltinExtensionEnabled;
    }

    @Override
    public Set<String> getExcludes() {
        return this.excludes;
    }

    @Override
    public boolean computeFrames() {
        return this.computeFrames;
    }

    @Override
    public boolean isGrantPackageAccess() {
        return this.grantPackageAccess;
    }

    @Override
    public long getShutdownDelayInNanos() {
        return this.shutdownDelayInNanos;
    }

    @Override
    public final AnnotationMatcher getIgnoreTransactionAnnotationMatcher() {
        return this.ignoreTransactionAnnotationMatcher;
    }

    @Override
    public final AnnotationMatcher getIgnoreApdexAnnotationMatcher() {
        return this.ignoreApdexAnnotationMatcher;
    }

    @Override
    public AnnotationMatcher getTraceAnnotationMatcher() {
        return this.traceAnnotationMatcher;
    }

    @Override
    public int getMaxPreValidatedClassLoaders() {
        return this.maxPreValidatedClassLoaders;
    }

    @Override
    public boolean preValidateWeavePackages() {
        return this.preValidateWeavePackages;
    }

    @Override
    public boolean preMatchWeaveMethods() {
        return this.preMatchWeaveMethods;
    }

    @Override
    public Collection<String> getJdbcStatements() {
        String jdbcStatementsProp = (String)this.getProperty(JDBC_STATEMENTS_PROPERTY);
        if (jdbcStatementsProp == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(jdbcStatementsProp.split(",[\\s]*"));
    }

    static ClassTransformerConfig createClassTransformerConfig(Map<String, Object> settings, boolean custom_tracing, boolean litemode) {
        if (settings == null) {
            settings = Collections.emptyMap();
        }
        return new ClassTransformerConfigImpl(settings, custom_tracing, litemode);
    }

    @Override
    public Config getInstrumentationConfig(String implementationTitle) {
        Object pointCutConfig;
        Map config = Collections.emptyMap();
        if (implementationTitle != null && (pointCutConfig = this.getProperty(implementationTitle)) instanceof Map) {
            config = (Map)pointCutConfig;
        }
        return new BaseConfig(config, SYSTEM_PROPERTY_ROOT + implementationTitle + ".");
    }

    @Override
    public boolean isWeavePackageEnabled(WeavePackageConfig weavePackageConfig) {
        Config aliasConfig;
        String moduleName = weavePackageConfig.getName();
        Config instrumentationConfig = this.getInstrumentationConfig(moduleName);
        Boolean moduleNameEnabled = null;
        if (instrumentationConfig != null) {
            moduleNameEnabled = (Boolean)instrumentationConfig.getProperty(ENABLED);
        }
        String aliasName = weavePackageConfig.getAlias();
        Boolean aliasEnabled = null;
        if (aliasName != null && (aliasConfig = this.getInstrumentationConfig(aliasName)) != null) {
            Agent.LOG.log(Level.INFO, "Using deprecated configuration setting {0} for instrumentation {1}", new Object[]{aliasName, moduleName});
            aliasEnabled = (Boolean)aliasConfig.getProperty(ENABLED);
        }
        Agent.LOG.log(Level.FINEST, " ### Considering instrumentation: {0}({1}) enabled?{2}({3})", new Object[]{moduleName, aliasName, moduleNameEnabled, aliasEnabled});
        if (moduleNameEnabled == null && aliasEnabled == null && !this.isDefaultInstrumentationEnabled) {
            Agent.LOG.log(Level.FINEST, " Instrumentation is disabled by default. Skipping: {0} because it is not explicitly enabled.", new Object[]{moduleName});
            return false;
        }
        if (moduleNameEnabled == null && aliasEnabled == null && this.isDefaultInstrumentationEnabled) {
            return weavePackageConfig.isEnabled();
        }
        if (moduleNameEnabled == null) {
            return aliasEnabled;
        }
        if (aliasEnabled == null) {
            return moduleNameEnabled;
        }
        return aliasEnabled != false && moduleNameEnabled != false;
    }

    @Override
    public boolean isDefaultMethodTracingEnabled() {
        return this.defaultMethodTracingEnabled;
    }
}

