/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.service.analytics;

import com.newrelic.agent.model.ApdexPerfZone;
import com.newrelic.agent.model.CountedDuration;
import com.newrelic.agent.model.PathHashes;
import com.newrelic.agent.model.SyntheticsIds;
import com.newrelic.agent.model.SyntheticsInfo;
import com.newrelic.agent.model.TimeoutCause;
import com.newrelic.agent.model.TransactionTiming;
import com.newrelic.agent.service.analytics.TransactionEvent;
import java.util.HashMap;
import java.util.Map;

public class TransactionEventBuilder {
    private String appName;
    private long timestamp;
    private String name;
    private float duration;
    private String guid;
    private String referringGuid;
    private Integer port;
    private String tripId;
    private ApdexPerfZone apdexPerfZone;
    private SyntheticsIds syntheticsIds;
    private SyntheticsInfo syntheticsInfo;
    private boolean error;
    private float pTotalTime;
    private TimeoutCause timeoutCause;
    private float priority;
    private final Map<String, Object> userAttributes = new HashMap<String, Object>();
    private Map<String, Object> distributedTraceIntrinsics;
    private float timeToFirstByte = Float.NEGATIVE_INFINITY;
    private float timeToLastByte = Float.NEGATIVE_INFINITY;
    private PathHashes pathHashes;
    private float queueDuration = Float.NEGATIVE_INFINITY;
    private float gcCumulative = Float.NEGATIVE_INFINITY;
    private CountedDuration external = CountedDuration.UNASSIGNED;
    private CountedDuration database = CountedDuration.UNASSIGNED;

    public TransactionEventBuilder setAppName(String appName) {
        this.appName = appName;
        return this;
    }

    public TransactionEventBuilder setTimestamp(long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public TransactionEventBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public TransactionEventBuilder setDuration(float duration) {
        this.duration = duration;
        return this;
    }

    public TransactionEventBuilder setGuid(String guid) {
        this.guid = guid;
        return this;
    }

    public TransactionEventBuilder setReferringGuid(String referringGuid) {
        this.referringGuid = referringGuid;
        return this;
    }

    public TransactionEventBuilder setPort(Integer port) {
        this.port = port;
        return this;
    }

    public TransactionEventBuilder setTripId(String tripId) {
        this.tripId = tripId;
        return this;
    }

    public TransactionEventBuilder setApdexPerfZone(ApdexPerfZone apdexPerfZone) {
        this.apdexPerfZone = apdexPerfZone;
        return this;
    }

    public TransactionEventBuilder setError(boolean error) {
        this.error = error;
        return this;
    }

    public TransactionEventBuilder setpTotalTime(float pTotalTime) {
        this.pTotalTime = pTotalTime;
        return this;
    }

    public TransactionEventBuilder setTimeoutCause(TimeoutCause timeoutCause) {
        this.timeoutCause = timeoutCause;
        return this;
    }

    public TransactionEventBuilder setPriority(float priority) {
        this.priority = priority;
        return this;
    }

    public TransactionEventBuilder putAllUserAttributes(Map<String, Object> additionalAttributes) {
        this.userAttributes.putAll(additionalAttributes);
        return this;
    }

    public TransactionEventBuilder setDistributedTraceIntrinsics(Map<String, Object> distributedTraceIntrinsics) {
        this.distributedTraceIntrinsics = distributedTraceIntrinsics;
        return this;
    }

    public TransactionEventBuilder setTimeToFirstByte(float timeToFirstByte) {
        this.timeToFirstByte = timeToFirstByte;
        return this;
    }

    public TransactionEventBuilder setTimeToLastByte(float timeToLastByte) {
        this.timeToLastByte = timeToLastByte;
        return this;
    }

    public TransactionEventBuilder setSyntheticsIds(SyntheticsIds syntheticsIds) {
        this.syntheticsIds = syntheticsIds;
        return this;
    }

    public TransactionEventBuilder setSyntheticsInfo(SyntheticsInfo syntheticsInfo) {
        this.syntheticsInfo = syntheticsInfo;
        return this;
    }

    public TransactionEventBuilder setPathHashes(PathHashes pathHashes) {
        this.pathHashes = pathHashes;
        return this;
    }

    public TransactionEventBuilder setQueueDuration(float queueDuration) {
        this.queueDuration = queueDuration;
        return this;
    }

    public TransactionEventBuilder setExternal(CountedDuration external) {
        this.external = external;
        return this;
    }

    public TransactionEventBuilder setDatabase(CountedDuration database) {
        this.database = database;
        return this;
    }

    public TransactionEventBuilder setGcCumulative(float gcCumulative) {
        this.gcCumulative = gcCumulative;
        return this;
    }

    public TransactionEvent build() {
        if (this.syntheticsIds == null) {
            this.syntheticsIds = new SyntheticsIds(null, null, null);
        }
        if (this.syntheticsInfo == null) {
            this.syntheticsInfo = new SyntheticsInfo(null, null, null);
        }
        if (this.pathHashes == null) {
            this.pathHashes = new PathHashes(null, null, null);
        }
        TransactionTiming timing = TransactionTiming.builder().duration(this.duration).totalTime(this.pTotalTime).timeToFirstByte(this.timeToFirstByte).timeToLastByte(this.timeToLastByte).queueDuration(this.queueDuration).external(this.external).database(this.database).gcCumulative(this.gcCumulative).build();
        return new TransactionEvent(this.appName, this.userAttributes, this.timestamp, this.name, timing, this.guid, this.referringGuid, this.port, this.tripId, this.pathHashes, this.apdexPerfZone, this.syntheticsIds, this.syntheticsInfo, this.error, this.timeoutCause, this.priority, this.distributedTraceIntrinsics);
    }
}

