/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.jfr.tosummary;

import com.newrelic.jfr.tosummary.EventToSummary;
import com.newrelic.jfr.tosummary.LongSummarizer;
import com.newrelic.jfr.tosummary.SimpleDurationSummarizer;
import com.newrelic.telemetry.Attributes;
import com.newrelic.telemetry.metrics.Summary;
import java.util.stream.Stream;
import jdk.jfr.consumer.RecordedEvent;

public class PerThreadNetworkWriteSummarizer
implements EventToSummary {
    public static final String SIMPLE_CLASS_NAME = PerThreadNetworkWriteSummarizer.class.getSimpleName();
    public static final String BYTES_WRITTEN = "bytesWritten";
    public static final String THREAD_NAME = "thread.name";
    public static final String JFR_SOCKET_WRITE_BYTES_WRITTEN = "jfr.SocketWrite.bytesWritten";
    public static final String JFR_SOCKET_WRITE_DURATION = "jfr.SocketWrite.duration";
    private final String threadName;
    private final LongSummarizer bytesSummary;
    private final SimpleDurationSummarizer duration;

    public PerThreadNetworkWriteSummarizer(String threadName, long startTimeMs) {
        this(threadName, new LongSummarizer(BYTES_WRITTEN), new SimpleDurationSummarizer(startTimeMs));
    }

    public PerThreadNetworkWriteSummarizer(String threadName, LongSummarizer longSummarizer, SimpleDurationSummarizer duration) {
        this.threadName = threadName;
        this.bytesSummary = longSummarizer;
        this.duration = duration;
    }

    @Override
    public String getEventName() {
        return "jdk.SocketWrite";
    }

    @Override
    public void accept(RecordedEvent ev) {
        this.bytesSummary.accept(ev);
        this.duration.accept(ev);
    }

    @Override
    public Stream<Summary> summarize() {
        Attributes attr = new Attributes().put(THREAD_NAME, this.threadName);
        Summary outWritten = new Summary(JFR_SOCKET_WRITE_BYTES_WRITTEN, this.bytesSummary.getCount(), this.bytesSummary.getSum(), this.bytesSummary.getMin(), this.bytesSummary.getMax(), this.duration.getStartTimeMs(), this.duration.getEndTimeMs(), attr);
        Summary outDuration = new Summary(JFR_SOCKET_WRITE_DURATION, this.bytesSummary.getCount(), this.duration.getDurationMillis(), this.duration.getMinDurationMillis(), this.duration.getMaxDurationMillis(), this.duration.getStartTimeMs(), this.duration.getEndTimeMs(), attr);
        return Stream.of(outWritten, outDuration);
    }

    @Override
    public void reset() {
        this.bytesSummary.reset();
        this.duration.reset();
    }
}

