/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.profile.v2;

import com.newrelic.agent.deps.org.json.simple.JSONArray;
import com.newrelic.agent.profile.v2.ProfileSegment;
import com.newrelic.agent.profile.v2.ProfiledMethod;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;

public class SimpleProfileSegment
extends ProfileSegment {
    private int runnableCallCount = 0;
    private int nonrunnableCallCount = 0;

    private SimpleProfileSegment(ProfiledMethod method) {
        super(method);
    }

    public static SimpleProfileSegment newProfileSegment(ProfiledMethod method) {
        if (method == null) {
            return null;
        }
        return new SimpleProfileSegment(method);
    }

    protected SimpleProfileSegment createProfileSegment(ProfiledMethod method) {
        return SimpleProfileSegment.newProfileSegment(method);
    }

    @Override
    public void writeJSONString(Writer out) throws IOException {
        JSONArray.writeJSONString(Arrays.asList(this.method, this.runnableCallCount, this.nonrunnableCallCount, new ArrayList(this.children.values())), out);
    }

    public String toString() {
        return this.method.toString();
    }

    @Override
    protected int getRunnableCallCount() {
        return this.runnableCallCount;
    }

    @Override
    public void incrementCallCount(boolean runnable) {
        if (runnable) {
            ++this.runnableCallCount;
        } else {
            ++this.nonrunnableCallCount;
        }
    }

    @Override
    public int getCallSiteCount() {
        int count = 1;
        for (ProfileSegment segment : this.children.values()) {
            count += segment.getCallSiteCount();
        }
        return count;
    }

    @Override
    public int getCallCount(ProfiledMethod method) {
        int count = method.equals(this.getMethod()) ? this.runnableCallCount : 0;
        for (ProfileSegment kid : this.children.values()) {
            count += kid.getCallCount(method);
        }
        return count;
    }
}

