/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.config.BaseConfig;
import com.newrelic.agent.config.SamplerConfig;
import java.util.Collections;
import java.util.Map;

public class DistributedTracingConfig
extends BaseConfig {
    private static final boolean DEFAULT_DISTRIBUTED_TRACING = true;
    private static final String SYSTEM_PROPERTY_ROOT = "newrelic.config.distributed_tracing.";
    public static final String ENABLED = "enabled";
    public static final String TRUSTED_ACCOUNT_KEY = "trusted_account_key";
    public static final String ACCOUNT_ID = "account_id";
    public static final String PRIMARY_APPLICATION_ID = "primary_application_id";
    public static final String DISTRIBUTED_TRACING_ENABLED = "newrelic.config.distributed_tracing.enabled";
    public static final String ENABLED_ENV_KEY = "NEW_RELIC_DISTRIBUTED_TRACING_ENABLED";
    public static final String EXCLUDE_NEWRELIC_HEADER = "exclude_newrelic_header";
    private final boolean enabled = this.getProperty("enabled", true);
    private final String trustedAccountKey = (String)this.getProperty("trusted_account_key");
    private final String accountId = (String)this.getProperty("account_id");
    private final String primaryApplicationId = (String)this.getProperty("primary_application_id");
    private final boolean includeNewRelicHeader = this.getProperty("exclude_newrelic_header", false) == false;
    private final SamplerConfig rootSamplerConfig = this.createSamplerConfig("root");
    private final SamplerConfig remoteParentSampledConfig = this.createSamplerConfig("remote_parent_sampled");
    private final SamplerConfig remoteParentNotSampledConfig = this.createSamplerConfig("remote_parent_not_sampled");
    private final Integer adaptiveSamplingTarget = this.rootSamplerConfig.getAdaptiveSamplingTarget();

    DistributedTracingConfig(Map<String, Object> props) {
        super(props, SYSTEM_PROPERTY_ROOT);
    }

    public String getTrustedAccountKey() {
        return this.trustedAccountKey;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getPrimaryApplicationId() {
        return this.primaryApplicationId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public boolean isIncludeNewRelicHeader() {
        return this.includeNewRelicHeader;
    }

    public Integer getAdaptiveSamplingTarget() {
        return this.adaptiveSamplingTarget;
    }

    private SamplerConfig createSamplerConfig(String samplerType) {
        Map<String, Object> samplerProps = this.getProperty("sampler", Collections.emptyMap());
        return new SamplerConfig(samplerType, samplerProps, this.systemPropertyPrefix);
    }

    public SamplerConfig getRootSamplerConfig() {
        return this.rootSamplerConfig;
    }

    public SamplerConfig getRemoteParentSampledSamplerConfig() {
        return this.remoteParentSampledConfig;
    }

    public SamplerConfig getRemoteParentNotSampledSamplerConfig() {
        return this.remoteParentNotSampledConfig;
    }
}

