/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.cloud;

import com.newrelic.agent.MetricNames;
import com.newrelic.agent.bridge.AgentBridge;
import com.newrelic.agent.bridge.CloudApi;
import com.newrelic.agent.cloud.AwsAccountDecoder;
import com.newrelic.agent.cloud.AwsAccountDecoderImpl;
import com.newrelic.agent.cloud.CloudAccountInfoCache;
import com.newrelic.api.agent.CloudAccountInfo;

public class CloudApiImpl
implements CloudApi {
    private final CloudAccountInfoCache accountInfoCache;
    private final AwsAccountDecoder awsAccountDecoder;

    private CloudApiImpl() {
        this(new CloudAccountInfoCache(), AwsAccountDecoderImpl.newInstance());
        this.accountInfoCache.retrieveDataFromConfig();
    }

    CloudApiImpl(CloudAccountInfoCache accountInfoCache, AwsAccountDecoder awsAccountDecoder) {
        this.accountInfoCache = accountInfoCache;
        this.awsAccountDecoder = awsAccountDecoder;
    }

    public static void initialize() {
        AgentBridge.cloud = new CloudApiImpl();
    }

    public void setAccountInfo(CloudAccountInfo cloudAccountInfo, String value) {
        MetricNames.recordApiSupportabilityMetric("Cloud/SetAccountInfo/" + cloudAccountInfo.toString());
        this.accountInfoCache.setAccountInfo(cloudAccountInfo, value);
    }

    public void setAccountInfo(Object sdkClient, CloudAccountInfo cloudAccountInfo, String value) {
        MetricNames.recordApiSupportabilityMetric("Cloud/SetAccountInfoClient/" + cloudAccountInfo.toString());
        this.accountInfoCache.setAccountInfo(sdkClient, cloudAccountInfo, value);
    }

    public String getAccountInfo(CloudAccountInfo cloudAccountInfo) {
        return this.accountInfoCache.getAccountInfo(cloudAccountInfo);
    }

    public String getAccountInfo(Object sdkClient, CloudAccountInfo cloudAccountInfo) {
        return this.accountInfoCache.getAccountInfo(sdkClient, cloudAccountInfo);
    }

    public String decodeAwsAccountId(String accessKey) {
        return this.awsAccountDecoder.decodeAccount(accessKey);
    }
}

