/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.browser;

import com.newrelic.agent.Agent;
import com.newrelic.agent.browser.BrowserConfig;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.AgentConfigFactory;
import com.newrelic.agent.config.BaseConfig;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

class BrowserConfigFactory {
    BrowserConfigFactory() {
    }

    static BrowserConfig createBrowserConfig(String appName, AgentConfig agentConfig) {
        try {
            BrowserConfig browserConfig = BrowserConfigFactory.createTheBrowserConfig(appName, ((BaseConfig)((Object)agentConfig)).getProperties());
            boolean autoInstrumentEnabled = agentConfig.getBrowserMonitoringConfig().isAutoInstrumentEnabled();
            String msg = MessageFormat.format("Real user monitoring is enabled for application {0}. Auto instrumentation is {1}.", appName, autoInstrumentEnabled ? "enabled" : "disabled");
            Agent.LOG.info(msg);
            return browserConfig;
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Unable to configure application \"{0}\" for Real User Monitoring: {1}", appName, e);
            if (Agent.LOG.isLoggable(Level.FINEST)) {
                Agent.LOG.log(Level.FINEST, msg, e);
            } else {
                Agent.LOG.finer(msg);
            }
            Agent.LOG.info(MessageFormat.format("Real user monitoring is not enabled for application \"{0}\"", appName));
            return null;
        }
    }

    private static BrowserConfig createTheBrowserConfig(String appName, Map<String, Object> serverData) throws Exception {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        BrowserConfigFactory.mergeBrowserSettings(settings, serverData);
        Map<String, Object> agentData = AgentConfigFactory.getAgentData(serverData);
        BrowserConfigFactory.mergeBrowserSettings(settings, agentData);
        return BrowserConfig.createBrowserConfig(appName, settings);
    }

    private static void mergeBrowserSettings(Map<String, Object> settings, Map<String, Object> data) {
        if (data == null) {
            return;
        }
        BrowserConfigFactory.mergeSetting("browser_key", settings, data);
        BrowserConfigFactory.mergeSetting("browser_monitoring.loader_version", settings, data);
        BrowserConfigFactory.mergeSetting("js_agent_loader", settings, data);
        BrowserConfigFactory.mergeSetting("js_agent_file", settings, data);
        BrowserConfigFactory.mergeSetting("beacon", settings, data);
        BrowserConfigFactory.mergeSetting("error_beacon", settings, data);
        BrowserConfigFactory.mergeSetting("application_id", settings, data);
    }

    private static void mergeSetting(String currentSetting, Map<String, Object> settings, Map<String, Object> data) {
        Object val = data.get(currentSetting);
        if (val != null) {
            settings.put(currentSetting, val);
        }
    }
}

