/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.Agent;
import com.newrelic.agent.config.Config;
import com.newrelic.agent.config.DeprecatedProperty;
import com.newrelic.agent.config.ServerProp;
import com.newrelic.agent.config.SystemPropertyFactory;
import com.newrelic.agent.deps.org.json.simple.parser.JSONParser;
import com.newrelic.agent.deps.org.json.simple.parser.ParseException;
import com.newrelic.api.agent.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;

public class BaseConfig
implements Config {
    public static final String COMMA_SEPARATOR = ",";
    public static final String SEMI_COLON_SEPARATOR = ";";
    protected static boolean addDeprecatedProperties = true;
    private static final Logger logger = Agent.LOG.getChildLogger(BaseConfig.class);
    private final Map<String, Object> props;
    protected final String systemPropertyPrefix;
    protected static final Map<String[], DeprecatedProperty> deprecatedProperties = new ConcurrentHashMap<String[], DeprecatedProperty>();

    public BaseConfig(Map<String, Object> props) {
        this(props, null);
    }

    public BaseConfig(Map<String, Object> props, String systemPropertyPrefix) {
        if (systemPropertyPrefix != null && systemPropertyPrefix.length() == 0) {
            throw new IllegalArgumentException("prefix must be null or non-empty");
        }
        this.props = props == null ? Collections.emptyMap() : Collections.unmodifiableMap(props);
        this.systemPropertyPrefix = systemPropertyPrefix;
    }

    public Map<String, Object> getProperties() {
        return this.props;
    }

    protected Map<String, Object> nestedProps(String key) {
        Object value = this.getProperties().get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof ServerProp) {
            value = ((ServerProp)value).getValue();
        }
        if (value instanceof Map) {
            return (Map)value;
        }
        logger.log(Level.WARNING, "Agent configuration expected nested configuration values for \"{0}\", got \"{1}\"", (Object)key, value);
        return null;
    }

    protected Object getPropertyFromSystemProperties(String name, Object defaultVal) {
        if (this.systemPropertyPrefix == null) {
            return null;
        }
        String key = this.getSystemPropertyKey(name);
        String result = SystemPropertyFactory.getSystemPropertyProvider().getSystemProperty(key);
        return BaseConfig.parseValue(result);
    }

    protected String getSystemPropertyKey(String key) {
        if (key == null) {
            throw new IllegalArgumentException("key");
        }
        return this.systemPropertyPrefix + key;
    }

    protected Object getPropertyFromSystemEnvironment(String name, Object defaultVal) {
        if (this.systemPropertyPrefix == null) {
            return null;
        }
        String key = this.getSystemPropertyKey(name);
        String result = SystemPropertyFactory.getSystemPropertyProvider().getEnvironmentVariable(key);
        return BaseConfig.parseValue(result);
    }

    static Object parseValue(String val) {
        if (val == null) {
            return null;
        }
        try {
            return new JSONParser().parse(val);
        }
        catch (ParseException e) {
            return val;
        }
    }

    @Override
    public <T> T getProperty(String key, T defaultVal) {
        Object propVal = this.getProperties().get(key);
        if (propVal instanceof ServerProp) {
            propVal = ((ServerProp)propVal).getValue();
            return this.castValue(key, propVal, defaultVal);
        }
        Object override = this.getPropertyFromSystemEnvironment(key, defaultVal);
        if (override != null) {
            return this.castValue(key, override, defaultVal);
        }
        override = this.getPropertyFromSystemProperties(key, defaultVal);
        if (override != null) {
            return this.castValue(key, override, defaultVal);
        }
        return this.castValue(key, propVal, defaultVal);
    }

    protected <T> T castValue(String key, Object value, T defaultVal) {
        try {
            if (defaultVal instanceof Integer && value instanceof Long) {
                return (T)Integer.valueOf(((Long)value).intValue());
            }
            if (defaultVal instanceof Boolean && value instanceof String) {
                return (T)Boolean.valueOf((String)value);
            }
            Object val = value;
            if (val == null) {
                return defaultVal;
            }
            if (val instanceof String) {
                return (T)((String)val).trim();
            }
            return (T)val;
        }
        catch (ClassCastException e) {
            logger.log(Level.FINE, (Throwable)e, "Unable to parse {0}", (Object)key);
            return defaultVal;
        }
    }

    @Override
    public <T> T getProperty(String key) {
        return this.getProperty(key, null);
    }

    protected Set<Integer> getIntegerSet(String key, Set<Integer> defaultVal) {
        Object val = this.getProperty(key);
        if (val instanceof String) {
            return Collections.unmodifiableSet(this.getIntegerSetFromString((String)val));
        }
        if (val instanceof Collection) {
            return Collections.unmodifiableSet(this.getIntegerSetFromCollection((Collection)val));
        }
        if (val instanceof Integer) {
            return Collections.unmodifiableSet(this.getIntegerSetFromCollection(Collections.singletonList((Integer)val)));
        }
        return defaultVal;
    }

    protected List<String> getUniqueStrings(String key) {
        return this.getUniqueStrings(key, COMMA_SEPARATOR);
    }

    protected List<String> getUniqueStrings(String key, String separator) {
        Object val = this.getProperty(key);
        if (val instanceof String) {
            return Collections.unmodifiableList(BaseConfig.getUniqueStringsFromString((String)val, separator));
        }
        if (val instanceof Collection) {
            return Collections.unmodifiableList(BaseConfig.getUniqueStringsFromCollection((Collection)val));
        }
        return Collections.emptyList();
    }

    public static List<String> getUniqueStringsFromCollection(Collection<?> values2, String prefix) {
        ArrayList<String> result = new ArrayList<String>(values2.size());
        boolean noPrefix = prefix == null || prefix.isEmpty();
        for (Object value : values2) {
            String val = value instanceof Integer ? String.valueOf(value) : (value instanceof Long ? String.valueOf(value) : (String)value);
            val = val.trim();
            if (val.length() == 0 || result.contains(val)) continue;
            if (noPrefix) {
                result.add(val);
                continue;
            }
            result.add(prefix + val);
        }
        return result;
    }

    public static List<String> getUniqueStringsFromCollection(Collection<?> values2) {
        return BaseConfig.getUniqueStringsFromCollection(values2, null);
    }

    public static List<String> getUniqueStringsFromString(String valuesString, String separator) {
        String[] valuesArray = valuesString.split(separator);
        ArrayList<String> result = new ArrayList<String>(valuesArray.length);
        for (String value : valuesArray) {
            if ((value = value.trim()).length() == 0 || result.contains(value)) continue;
            result.add(value);
        }
        return result;
    }

    protected int getIntProperty(String key, int defaultVal) {
        Number val = (Number)this.getProperty(key);
        if (val == null) {
            return defaultVal;
        }
        return val.intValue();
    }

    protected String getStringPropertyOrNull(String key) {
        Object val = this.getProperty(key);
        if (val == null) {
            logger.log(Level.FINE, "Value for \"{0}\" is null", (Object)key);
            return null;
        }
        return val.toString();
    }

    protected double getDoubleProperty(String key, double defaultVal) {
        Number val = (Number)this.getProperty(key);
        if (val == null) {
            return defaultVal;
        }
        return val.doubleValue();
    }

    private Set<Integer> getIntegerSetFromCollection(Collection<?> values2) {
        HashSet<Integer> result = new HashSet<Integer>(values2.size());
        for (Object value : values2) {
            int val = ((Number)value).intValue();
            result.add(val);
        }
        return result;
    }

    private Set<Integer> getIntegerSetFromString(String valuesString) {
        String[] valuesArray = valuesString.split(COMMA_SEPARATOR);
        HashSet<Integer> result = new HashSet<Integer>(valuesArray.length);
        for (String value : valuesArray) {
            if ((value = value.trim()).length() == 0) continue;
            result.add(Integer.parseInt(value));
        }
        return result;
    }

    protected static void addDeprecatedProperty(String[] deprecatedProperty, String[] newProperty) {
        if (addDeprecatedProperties) {
            deprecatedProperties.put(deprecatedProperty, new DeprecatedProperty(deprecatedProperty, newProperty));
        }
    }

    protected static void clearDeprecatedProperties() {
        deprecatedProperties.clear();
    }
}

