/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.weave.utils;

import com.newrelic.weave.utils.ClassFinder;
import com.newrelic.weave.utils.WeaveUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;

public class ClassClassFinder
implements ClassFinder {
    private final URL baseLocation;
    private final boolean isJar;

    public ClassClassFinder(Class<?> clazz) {
        ProtectionDomain pd = clazz.getProtectionDomain();
        if (null != pd) {
            CodeSource cs = pd.getCodeSource();
            if (cs != null) {
                this.baseLocation = cs.getLocation();
                this.isJar = this.baseLocation != null && this.baseLocation.toExternalForm().endsWith(".jar");
            } else {
                this.baseLocation = null;
                this.isJar = false;
            }
        } else {
            this.baseLocation = null;
            this.isJar = false;
        }
    }

    @Override
    public URL findResource(String internalName) {
        URL classLocation = null;
        if (null != this.baseLocation) {
            try {
                classLocation = this.isJar ? new URL("jar:" + this.baseLocation.toExternalForm() + "!/" + WeaveUtils.getClassResourceName(internalName)) : new URL(this.baseLocation, WeaveUtils.getClassResourceName(internalName));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return classLocation;
    }
}

